package com.thr.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.idcard.Demo;
import com.idcard.GlobalData;
import com.idcard.StringManager;
import com.idcard.TOCR;
import com.thr.common.CommonResult;
import com.thr.dto.IdcardDto;
import com.thr.dto.Param;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

@Service
@Slf4j
public class OcrService {


    public CommonResult idcard(Param param){
        String imgStr = param.getImgstr();
        String imgUrl = param.getImgurl();
        if(StrUtil.isEmpty(imgStr) && StrUtil.isEmpty(imgUrl)){
            return CommonResult.validateFailed();
        }
        String img = null;
        if(!StrUtil.isEmpty(imgStr)){
            img = imgStr;
        }else {
            try {
                byte[] bytes = HttpUtil.createGet(imgUrl).execute().bodyBytes();
                img = Base64.getEncoder().encodeToString(bytes);
            }catch (Exception e){
                img = null;
            }
        }
        if(img == null){
            return CommonResult.validateFailed();
        }
        byte[] imgBytes = Base64.getDecoder().decode(img);
        if(imgBytes == null || imgBytes.length == 0){
            return CommonResult.validateFailed();
        }
        byte[] jsonbuf = Demo.RECOCROFMEM(GlobalData.TIDCARD2, imgBytes, imgBytes.length);
        if (jsonbuf == null){
            return CommonResult.failed("识别失败");
        }
        String strResult = null;
        try {
            strResult = new String(jsonbuf, "GBK");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        strResult = strResult.replace("\u0000", "");
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.serializeNulls();
        Gson gson = gsonbuilder.create();
        TOCR tocr = gson.fromJson(strResult, TOCR.class);
        StringManager data = tocr.getData().get(0);
        IdcardDto dto = new IdcardDto();
        dto.setName(data.getIDC_NAME());
        dto.setIdcard(data.getIDC_NUM());
        dto.setSex(data.getIDC_SEX());
        dto.setBirth(data.getIDC_BIRTHDAY());
        dto.setNation(data.getIDC_FOLK());
        dto.setQuality(data.getIMG_QUALITY());
        dto.setAddress(data.getIDC_ADDRESS());
        if(param.isHead()){
            dto.setHeadimg(data.getHeadimg());
        }
        return CommonResult.success(dto);
    }

}
