package com.idcard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.*;

class OCREngine4 extends Thread {
    public String pathString;
    public Demo engineDemo;
    public int id;
    public int i = 0;
    public int num1 = 0;
    private CBInterface callBack = null;
    private int tEngineType = GlobalData.TUNCERTAIN;

    public OCREngine4(int tEngineType, Demo demo, String paString) {
        // TODO Auto-generated constructor stub
        this.pathString = paString;
        this.engineDemo = demo;
        this.tEngineType = tEngineType;
    }

    public void SetCallBack(CBInterface cbInterface) {
        this.callBack = cbInterface;
    }

    public static byte[] GetImgByte(String path) throws IOException {
        byte[] bytes = null;
        File file = null;
        file = new File(path);

        if (file.exists()) {
            InputStream is = new FileInputStream(file);
            int length = (int) file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            bytes = new byte[length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                return null;
            }
            is.close();
            return bytes;
        }
        return null;
    }

    public void run() {
//    	for (i = 0; i < 10; i++)
        {
            byte[] pImgBuff = null;
            try {
                pImgBuff = GetImgByte(pathString);
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            if (pImgBuff == null) {
                return;
            }
            //byte [] buf = engineDemo.RECOCROFPATH(pathString);
            byte[] jsonbuf = engineDemo.RECOCROFMEM(this.tEngineType, pImgBuff, pImgBuff.length);
            if (jsonbuf != null) {
                String strResult = null;
                try {
                    strResult = new String(jsonbuf, "GBK");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
    			System.out.print(strResult);
                strResult = strResult.replace("\u0000", "");
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.serializeNulls();
                Gson gson = gsonbuilder.create();
                TOCR tocr = gson.fromJson(strResult, TOCR.class);
                for (int i = 0; i < tocr.getData().size(); i++) {
                System.out.println("\r\n"+"号牌号码:" + tocr.getData().get(i).getDP_PLATENO() + "\r\n"
                        + "车牌类型:" + tocr.getData().get(i).getDP_TYPE() + "\r\n"
                        + "所有人:" + tocr.getData().get(i).getDP_OWNER() + "\r\n"
                        + "地址:" + tocr.getData().get(i).getDP_ADDRESS() + "\r\n"
                        + "使用性质:" + tocr.getData().get(i).getDP_USECHARACTER() + "\r\n"
                        + "品牌号码:" + tocr.getData().get(i).getDP_MODEL() + "\r\n"
                        + "车辆识别代号:" + tocr.getData().get(i).getDP_VIN() + "\r\n"
                        + "发动机号码:" + tocr.getData().get(i).getDP_ENGINENO() + "\r\n"
                        + "注册日期:" + tocr.getData().get(i).getDP_REGISTER_DATE() + "\r\n"
                        + "发证日期:" + tocr.getData().get(i).getDP_ISSUE_DATE() + "\r\n"

                        + "车牌号码:" + tocr.getData().get(i).getDP_B_PLATENUM() + "\r\n"
                        + "证号:" + tocr.getData().get(i).getDP_B_SERIAL() + "\r\n"
                        + "核定载人数:" + tocr.getData().get(i).getDP_B_PASSENGER() + "\r\n"
                        + "总质量:" + tocr.getData().get(i).getDP_B_GROSSMASS() + "\r\n"
                        + "整备质量:" + tocr.getData().get(i).getDP_B_CURBWEIGHT() + "\r\n"
                        + "核定载质量:" + tocr.getData().get(i).getDP_B_LOAD() + "\r\n"
                        + "外廓尺寸:" + tocr.getData().get(i).getDP_B_GABARITE() + "\r\n"
                        + "准牵引总质量:" + tocr.getData().get(i).getDP_B_TRACTIONMASS() + "\r\n"
                        + "备注:" + tocr.getData().get(i).getDP_B_REMARK() + "\r\n"
                        + "检验记录:" + tocr.getData().get(i).getDP_B_RECODE() + "\r\n"
                        + "条形码:" + tocr.getData().get(i).getDP_B_BARNUM() + "\r\n"
                        + "图片质量估计值:" + tocr.getData().get(i).getIMG_QUALITY() + "\r\n");
                }
//    			StringManager.SaveJPGFile("c:/345.jpg", stringManager.headimg.getBytes());// 人头像保存
            } else {
                System.out.print("buf == null\n");
            }
        }
//    	System.out.println("线程"+ id + "结束\n");
    }
}
