package com.idcard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.*;

class OCREngine12 extends Thread {
    public String pathString;
    public Demo engineDemo;
    public int id;
    public int i = 0;
    public int num1 = 0;
    private CBInterface callBack = null;
    private int tEngineType = GlobalData.TUNCERTAIN;

    public OCREngine12(int tEngineType, Demo demo, String paString) {
        // TODO Auto-generated constructor stub
        this.pathString = paString;
        this.engineDemo = demo;
        this.tEngineType = tEngineType;
    }

    public void SetCallBack(CBInterface cbInterface) {
        this.callBack = cbInterface;
    }

    public static byte[] GetImgByte(String path) throws IOException {
        byte[] bytes = null;
        File file = null;
        file = new File(path);

        if (file.exists()) {
            InputStream is = new FileInputStream(file);
            int length = (int) file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            bytes = new byte[length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                return null;
            }
            is.close();
            return bytes;
        }
        return null;
    }

    public void run() {
//    	for (i = 0; i < 10; i++)
        {
            byte[] pImgBuff = null;
            try {
                pImgBuff = GetImgByte(pathString);
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            if (pImgBuff == null) {
                return;
            }
            //byte [] buf = engineDemo.RECOCROFPATH(pathString);
            byte[] jsonbuf = engineDemo.RECOCROFMEM(this.tEngineType, pImgBuff, pImgBuff.length);
            if (jsonbuf != null) {
                String strResult = null;
                try {
                    strResult = new String(jsonbuf, "GBK");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                System.out.print(strResult);
                strResult = strResult.replace("\u0000", "");
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.serializeNulls();
                Gson gson = gsonbuilder.create();
                TOCR tocr = gson.fromJson(strResult, TOCR.class);
                for (int i = 0; i < tocr.getData().size(); i++) {
                    System.out.println("\r\n"+"持证人:" + tocr.getData().get(i).getMAR_OWNER() + "\r\n"
                            + "登记日期:" + tocr.getData().get(i).getMAR_PERIOD() + "\r\n"
                            + "结婚证字号:" + tocr.getData().get(i).getMAR_NUM() + "\r\n"
                            + "男方姓名:" + tocr.getData().get(i).getMAR_MAN() + "\r\n"
                            + "男方生日:" + tocr.getData().get(i).getMAR_MAN_BIRTH() + "\r\n"
                            + "男方证件号:" + tocr.getData().get(i).getMAR_MAN_NUM() + "\r\n"
                            + "女方姓名:" + tocr.getData().get(i).getMAR_WIFE() + "\r\n"
                            + "女方生日:" + tocr.getData().get(i).getMAR_WIFE_BIRTH() + "\r\n"
                            + "女方证件号:" + tocr.getData().get(i).getMAR_WIFE_NUM() + "\r\n");
                }
//    			StringManager.SaveJPGFile("c:/345.jpg", stringManager.headimg.getBytes());// 人头像保存
            } else {
                System.out.print("buf == null\n");
            }
        }
//    	System.out.println("线程"+ id + "结束\n");
    }
}
