package com.idcard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.*;

class OCREngine11 extends Thread {
    public String pathString;
    public Demo engineDemo;
    public int id;
    public int i = 0;
    public int num1 = 0;
    private CBInterface callBack = null;
    private int tEngineType = GlobalData.TUNCERTAIN;

    public OCREngine11(int tEngineType, Demo demo, String paString) {
        // TODO Auto-generated constructor stub
        this.pathString = paString;
        this.engineDemo = demo;
        this.tEngineType = tEngineType;
    }

    public void SetCallBack(CBInterface cbInterface) {
        this.callBack = cbInterface;
    }

    public static byte[] GetImgByte(String path) throws IOException {
        byte[] bytes = null;
        File file = null;
        file = new File(path);

        if (file.exists()) {
            InputStream is = new FileInputStream(file);
            int length = (int) file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            bytes = new byte[length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                return null;
            }
            is.close();
            return bytes;
        }
        return null;
    }

    public void run() {
//    	for (i = 0; i < 10; i++)
        {
            byte[] pImgBuff = null;
            try {
                pImgBuff = GetImgByte(pathString);
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            if (pImgBuff == null) {
                return;
            }
            //byte [] buf = engineDemo.RECOCROFPATH(pathString);
            byte[] jsonbuf = engineDemo.RECOCROFMEM(this.tEngineType, pImgBuff, pImgBuff.length);
            if (jsonbuf != null) {
                String strResult = null;
                try {
                    strResult = new String(jsonbuf, "GBK");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                System.out.print(strResult);
                strResult = strResult.replace("\u0000", "");
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.serializeNulls();
                Gson gson = gsonbuilder.create();
                TOCR tocr = gson.fromJson(strResult, TOCR.class);
                for (int i = 0; i < tocr.getData().size(); i++) {
                    System.out.println("\r\n"+"发票代号:" + tocr.getData().get(i).getINV_CODE() + "\r\n"
                            + "发票号码:" + tocr.getData().get(i).getINV_NUM() + "\r\n"
                            + "开票日期:" + tocr.getData().get(i).getINV_DATE() + "\r\n"
                            + "密码区:" + tocr.getData().get(i).getINV_PASSWORD() + "\r\n"
                            + "购方企业名称:" + tocr.getData().get(i).getINV_BUY() + "\r\n"
                            + "购方纳税号:" + tocr.getData().get(i).getINV_BUYCODE() + "\r\n"
                            + "销方企业名称:" + tocr.getData().get(i).getINV_SALE() + "\r\n"
                            + "销方纳税号:" + tocr.getData().get(i).getINV_SALECODE() + "\r\n"
                            + "货物或应税劳务名称:" + tocr.getData().get(i).getINV_PRODUCT() + "\r\n"
                            + "价税合计:" + tocr.getData().get(i).getINV_PRICE_TAX() + "\r\n"
                            + "合计金额:" + tocr.getData().get(i).getINV_PRICE() + "\r\n"
                            + "合计税额:" + tocr.getData().get(i).getINV_TAX() + "\r\n"
                            + "备注:" + tocr.getData().get(i).getINV_MARK() + "\r\n"
                            + "税率:" + tocr.getData().get(i).getINV_TAXRATE() + "\r\n");
                }
//    			StringManager.SaveJPGFile("c:/345.jpg", stringManager.headimg.getBytes());// 人头像保存
            } else {
                System.out.print("buf == null\n");
            }
        }
//    	System.out.println("线程"+ id + "结束\n");
    }
}
