package com.idcard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.*;
import java.util.Base64;

class OCREngine extends Thread {
    public String pathString;
    public Demo engineDemo;
    public int id;
    public int i = 0;
    public int num1 = 0;
    private CBInterface callBack = null;
    private int tEngineType = GlobalData.TUNCERTAIN;

    public OCREngine(int tEngineType, Demo demo, String paString) {
        // TODO Auto-generated constructor stub
        this.pathString = paString;
        this.engineDemo = demo;
        this.tEngineType = tEngineType;
    }

    public void SetCallBack(CBInterface cbInterface) {
        this.callBack = cbInterface;
    }

    public static byte[] GetImgByte(String path) throws IOException {
        byte[] bytes = null;
        File file = null;
        file = new File(path);

        if (file.exists()) {
            InputStream is = new FileInputStream(file);
            int length = (int) file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            bytes = new byte[length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                return null;
            }
            is.close();
            return bytes;
        }
        return null;
    }

    public void run() {
//    	for (i = 0; i < 10; i++)
        {
            long s1 = System.currentTimeMillis();
            byte[] pImgBuff = null;
            try {
                pImgBuff = GetImgByte(pathString);
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            if (pImgBuff == null) {
                return;
            }
            //byte [] buf = engineDemo.RECOCROFPATH(pathString);
            byte[] jsonbuf = engineDemo.RECOCROFMEM(this.tEngineType, pImgBuff, pImgBuff.length);
            if (jsonbuf != null) {
                String strResult = null;
                try {
                    strResult = new String(jsonbuf, "GBK");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
    			System.out.print(strResult);
                strResult = strResult.replace("\u0000", "");

                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.serializeNulls();
                Gson gson = gsonbuilder.create();
                TOCR tocr = gson.fromJson(strResult, TOCR.class);
                for (int i = 0; i < tocr.getData().size(); i++) {
                    System.out.println("\r\n"
                            + "姓名:" + tocr.getData().get(i).getIDC_NAME() + "\r\n"
                            + "性别:" + tocr.getData().get(i).getIDC_SEX() + "\r\n"
                            + "民族:" + tocr.getData().get(i).getIDC_FOLK() + "\r\n"
                            + "出生:" + tocr.getData().get(i).getIDC_BIRTHDAY() + "\r\n"
                            + "地址:" + tocr.getData().get(i).getIDC_ADDRESS() + "\r\n"
                            + "号码:" + tocr.getData().get(i).getIDC_NUM() + "\r\n"
                            + "签发机关:" + tocr.getData().get(i).getIDC_ISSUE() + "\r\n"
                            + "有效期限:" + tocr.getData().get(i).getIDC_PERIOD() + "\r\n"
                            + "图片质量估计值:" + tocr.getData().get(i).getIMG_QUALITY() + "\r\n");
                    FileOutputStream fw = null;
                    try {
                        fw = new FileOutputStream(new File("H:\\民政照片\\head\\"+tocr.getData().get(i).getIDC_NUM()+".jpg"));
                        fw.write(Base64.getDecoder().decode(tocr.getData().get(i).getHeadimg()));
                    } catch (IOException e) {
                        e.printStackTrace();
                    }finally {
                        try {
                            fw.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
//                    StringManager.SaveJPGFile("c:/123/001.jpg", tocr.getData().get(i).getHeadimg().getBytes());// 人头像保存
				}
            } else {
                System.out.print("buf == null\n");
            }
            System.out.println("用时:"+(System.currentTimeMillis()-s1));
        }
//    	System.out.println("线程"+ id + "结束\n");
    }
}
