package com.thr.config;

import com.idcard.Demo;
import com.idcard.GlobalData;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Configuration;
import java.io.*;
@Configuration
@Slf4j
public class NativeConfig {

    public static String key = null;


    static {
        try {
            //**//
            //loadLib("OCRDLL_THR_X64");
            //设置验证码
            //loadConfig("option.cfg");
            //**//

            //**//
            System.loadLibrary("OCRDLL_THR");
            //设置验证码
            Demo.RECOCRBoot("/usr/lib/linux_option.cfg");
            //**//


            //配置
            Demo.SetParam(GlobalData.T_SET_HEADIMG, 1);//设置是否要截取人头像信息
            Demo.SetParam(GlobalData.T_SET_HEADIMGBUFMODE, 1);//打开身份证保存区域图片的开关
            Demo.SetParam(GlobalData.T_SET_EVALUE_QUALITY, 1);//图像质量判断

        } catch (Exception e) {
            System.out.println("库加载失败");
        }
    }

    public static void loadLib(String libName) {
        String resourcePath = "/" + libName;
        String folderName = System.getProperty("java.io.tmpdir") + "/lib/";
        File folder = new File(folderName);
        folder.mkdirs();
        File libFile = new File(folder, libName);
        if (libFile.exists()) {
            System.load(libFile.getAbsolutePath());
        } else {
            try {
                InputStream in = NativeConfig.class.getResourceAsStream(resourcePath);
                FileUtils.copyInputStreamToFile(in,libFile);
                in.close();
                System.load(libFile.getAbsolutePath());
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to load required lib", e);
            }
        }
    }


    public static void loadConfig(String configName) {
        String resourcePath = "/" + configName;
        String folderName = System.getProperty("java.io.tmpdir") + "/lib/";
        File folder = new File(folderName);
        folder.mkdirs();
        File libFile = new File(folder, configName);
        if (libFile.exists()) {
            Demo.RECOCRBoot(libFile.getAbsolutePath());
        } else {
            try {
                InputStream in = NativeConfig.class.getResourceAsStream(resourcePath);
                FileUtils.copyInputStreamToFile(in,libFile);
                in.close();
                Demo.RECOCRBoot(libFile.getAbsolutePath());
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to load required lib", e);
            }
        }
    }
}
