package com.weface.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.weface.entity.UserTagEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户ID标签关联表
 *
 * @author chenshun
 * @date 2021-11-30 18:57:06
 */
@Mapper
public interface UserTagDao extends BaseMapper<UserTagEntity> {

    /**
     * 查询今天用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByTodayAndIdBefore(Integer id);

    /**
     * 根据时间查询用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit);

    /**
     * 查询库中无标签用户
     *
     * @return 用户信息
     */
    List<UserTagEntity> findNoTagUser(@Param("star") Integer star, @Param("end") Integer end);

    /**
     * 查询用户和标签信息
     *
     * @param page 分页
     * @param gid  银行gid
     * @param <T>  分页泛型
     * @return 用户标签数据
     */
    <T> IPage<UserTagEntity> getUserAndTags(Page<T> page, @Param("gid") String gid);

    /**
     * 根据标签查询用户gid
     *
     * @param list 标签数据
     * @return 用户gid
     */
    List<String> getGidByTag(List<String> list);

    /**
     * 根据gid查询用户标签
     *
     * @param gid 用户gid
     * @return 用户标签数据
     */
    List<UserTagEntity> getTagByGid(String gid);

    /**
     * 查询所有用户标签关联数据
     *
     * @return 用户标签数据
     */
    List<UserTagEntity> selectAllUserForTags();


}
