package com.weface.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.entity.MenuTagsEntity;
import com.weface.common.utils.PageUtils;

import java.util.Map;

/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
public interface MenuTagsService extends IService<MenuTagsEntity> {

    /**
     * 列表
     *
     * @param params 参数
     * @return 标签分页
     */
    PageUtils queryPage(Map<String, Object> params);

    /**
     * 根据code和权重查询标签
     *
     * @param code   编码
     * @param weight 权重
     * @return 标签信息
     */
    MenuTagsEntity getOneByCodeOrWeight(String code, String weight);
}

