package com.weface.serviceimpl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.dao.UserMenusDao;
import com.weface.entity.UserMenusEntity;
import com.weface.service.UserMenusService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Service("userMenusService")
@Transactional
public class UserMenusServiceImpl extends ServiceImpl<UserMenusDao, UserMenusEntity> implements UserMenusService {

    /**
     * 批量插入
     *
     * @param userMenusList 被插入数据
     */
    @Override
    public void batchInsert(List<UserMenusEntity> userMenusList) {
        if (CollectionUtils.isNotEmpty(userMenusList)) {
            List<String> deleteUid = getDeleteUid(userMenusList);
            //批量插入前全删
            List<Long> ids = this.baseMapper.findIdByUserId(deleteUid);
            this.removeByIds(ids);
            //获取集合长度
            int count = userMenusList.size();
            //每次批量插入个数
            int limit = 10000;
            int sum = 0;
            //计算页数
            int totalPage = (count % limit == 0) ? (count / limit) : (count / limit + 1);
            for (int i = 0; i < totalPage; i++) {
                List<UserMenusEntity> userMenusEntities = new ArrayList<>(10000);
                //如果是最后一页,则截取到最后
                if (i == totalPage - 1) {
                    userMenusEntities = userMenusList.subList(i * limit, count);
                } else {
                    userMenusEntities = userMenusList.subList(i * limit, (i + 1) * limit);
                }
                //批量插入每次一万条
                sum += this.baseMapper.batchInsert(userMenusEntities);
            }
            if (sum > 0) {
                log.warn("新增成功记录==" + sum + "==条");
            } else {
                log.error("新增失败");
            }
        }
    }

    /**
     * 查询删除的uid
     *
     * @param userMenusList 用户标签信息
     * @return 提取用户uid
     */
    private List<String> getDeleteUid(List<UserMenusEntity> userMenusList) {
        return userMenusList.stream().map(UserMenusEntity::getUserId).distinct().collect(Collectors.toList());
    }

}