package com.weface.component;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.weface.common.exception.RRException;
import com.weface.common.utils.Base64Util;
import com.weface.common.utils.HttpUtil;
import com.weface.common.utils.RedisUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author Administrator
 * @CreateTime: 2021/11/2
 */
@Slf4j
public class GeTuiUtils {
    public static final String KK_SH_APP_ID = "CYol79N33N71BV6dcjrqj3";
    public static final String KK_SH_MASTER_SECRET = "mekLZ4frLu7RHtKsN9mQn";
    public static final String KK_SH_APP_KEY = "rdLx5zumRK7oEme8MheAh8";

    public static final String KK_SB_APP_ID = "Ued41NRq7j9Nh1qI81gQ54";
    public static final String KK_SB_MASTER_SECRET = "b8MSgB7j8PAImc3eN0yuL9";
    public static final String KK_SB_APP_KEY = "2tLtJhcpij7lu3ksutgpU3";

    public static final String GE_TUI_BASE_URL = "https://restapi.getui.com/v2/";
    public static final String BASEURL = "https://openapi-gi.getui.com/v2/";
    public static final String ENCODING = "UTF-8";
    public static final String CONTENT_TYPE = "application/json;charset=utf-8";

    /**
     * 设置token过期时间为12小时
     */
    private final static long TIMEOUT = (12 * 60 * 60);

    /**
     * 获取token并缓存一份
     *
     * @param key 缓存key
     * @return 从缓存中拿token
     */
    public static String getAuthToken(String key) {
        String authToken = "";
        try {
            boolean flag = false;
            while (!flag) {
                flag = RedisUtil.LockOps.getLock("token", Thread.currentThread().getName());
                if (!flag) {
                    Thread.sleep(500L);
                }
            }
            //获取缓存内的token
            authToken = RedisUtil.StringOps.get(key);
            //如果不存在则调用个像接口获取
            if (StringUtils.isBlank(authToken)) {
                String geTui = null;
                switch (key) {
                    case "kk_sh_token":
                        authToken = getAuth(KK_SH_APP_ID, KK_SH_APP_KEY, KK_SH_MASTER_SECRET);
                        if (ObjectUtil.isNull(authToken)) {
                            throw new RRException("获取看看生活个像token失败");
                        }
                        break;
                    case "kk_sb_token":
                        authToken = getAuth(KK_SB_APP_ID, KK_SB_APP_KEY, KK_SB_MASTER_SECRET);
                        if (ObjectUtil.isNull(authToken)) {
                            throw new RRException("获取看看社保个像token失败");
                        }
                        break;
                    case "kk_sh_token_ge_tui":
                        authToken = getGeTuiAuth(KK_SH_APP_ID, KK_SH_APP_KEY, KK_SH_MASTER_SECRET);
                        if (ObjectUtil.isNull(authToken)) {
                            throw new RRException("获取看看生活个推token失败");
                        }
                        geTui = key;
                        break;
                    case "kk_sb_token_ge_tui":
                        authToken = getGeTuiAuth(KK_SB_APP_ID, KK_SB_APP_KEY, KK_SB_MASTER_SECRET);
                        if (ObjectUtil.isNull(authToken)) {
                            throw new RRException("获取看看社保个推token失败");
                        }
                        geTui = key;
                        break;
                    default:
                        break;
                }
                if (geTui != null) {
                    //获取token过期时间并转为数值,使token提前5秒过期
                    RedisUtil.StringOps.setEx(key, authToken, (TIMEOUT * 2) - 5, TimeUnit.SECONDS);
                } else {
                    //获取成功后放入缓存并设置token过期时间
                    RedisUtil.StringOps.setEx(key, authToken, TIMEOUT, TimeUnit.SECONDS);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("加锁失败!");
        } finally {
            RedisUtil.LockOps.releaseLock("token", Thread.currentThread().getName());
        }
        return authToken;
    }

    /**
     * 获取个像token
     *
     * @return JSONObject
     */
    private static String getAuth(String appId, String appKey, String masterSecret) {
        try {
            String getAccessTokenUrl = BASEURL + appId + "/auth_sign";
            Long timestamp = System.currentTimeMillis();
            JSONObject json = new JSONObject();
            json.put("sign", DigestUtils.sha256Hex(String.format("%s%d%s", appKey, timestamp, masterSecret)));
            json.put("timestamp", timestamp);
            HttpRequest post = HttpRequest.post(getAccessTokenUrl);
            String result = post.body(json.toString()).execute().body();
            JSONObject jsonObject = JSONObject.parseObject(result);
            if (jsonObject.containsKey("result") && "true".equals(jsonObject.getString("result"))) {
                String authtoken = jsonObject.getString("authtoken");
                log.info("获取个像token成功{}", authtoken);
                return authtoken;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取个像token失败!");
        }
        return null;
    }

    /**
     * 获取个推token
     *
     * @return JSONObject
     */
    public static String getGeTuiAuth(String appId, String appKey, String masterSecret) {
        try {
            // 获取token地址
            log.info("开始获取个推token");
            String getAccessTokenUrl = GE_TUI_BASE_URL + appId + "/auth";
            Long timestamp = System.currentTimeMillis();
            Map<String, Object> map = new HashMap<>();
            map.put("sign", Base64Util.getSign(appKey, timestamp, masterSecret));
            map.put("timestamp", timestamp);
            map.put("appkey", appKey);
            String result = HttpUtil.postGeneralUrl(getAccessTokenUrl, CONTENT_TYPE, JSONObject.toJSONString(map), ENCODING);
            if (HttpUtil.isJson2(result)) {
                JSONObject jsonObject = JSONObject.parseObject(result);
                if (jsonObject.containsKey("code") && jsonObject.getInteger("code") == 0) {
                    return jsonObject.getJSONObject("data").getString("token");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取个推token失败!");
        }
        return null;
    }

    /**
     * 获取看看生活个像
     *
     * @param gidList 用户gid
     * @param token   token
     * @return 请求结果
     * @throws Exception 抛出异常
     */
    public static String queryTagKKSH(List<String> gidList, String token) throws Exception {
        return queryTag(gidList, token, KK_SH_APP_ID);
    }

    /**
     * 获取看看生活个像
     *
     * @param gidList 用户gid
     * @param token   token
     * @return 请求结果
     * @throws Exception 抛出异常
     */
    public static String queryTagKKSB(List<String> gidList, String token) throws Exception {
        return queryTag(gidList, token, KK_SB_APP_ID);
    }

    /**
     * 根据giUid查询用户相关标签code
     *
     * @param gidList 用户gid
     * @param token   鉴权
     * @return 执行结果
     * @throws Exception 抛出异常
     */
    private static String queryTag(List<String> gidList, String token, String appId) throws Exception {
        //请求url
        String getUsersCidUrl = "https://openapi-gi.getui.com/v3/" + appId + "/query_tag";
        //将token以及用户ID封装调用画像查询接口
        Map<String, Object> map = new HashMap<>(2);
        map.put("userIdList", gidList);
        map.put("token", token);
        //发送post请求拿到当前用户的所有图像
        return HttpUtil.postGeneralUrl(getUsersCidUrl, CONTENT_TYPE, JSONObject.toJSONString(map), ENCODING);
    }


    /**
     * 删除鉴权token
     *
     * @param token 接口调用凭证token
     * @return 是否成功
     */
    public static boolean delToken(String token) {
        try {
            String body = HttpRequest.delete(GE_TUI_BASE_URL + KK_SH_APP_ID + "/auth" + token).execute().body();
            if (HttpUtil.isJson2(body)) {
                JSONObject jsonObject = JSONObject.parseObject(body);
                return jsonObject.containsKey("code") && jsonObject.getInteger("code") == 0;
            }
        } catch (HttpException e) {
            e.printStackTrace();
            log.error("删除个推鉴权token失败{}", e.getMessage());
        }
        return false;
    }

    /**
     * 【toSingle】执行别名单推
     *
     * @param alias           用户别名
     * @param messageTemplate 消息模板
     * @param token           接口访问凭据
     * @return 消息推送结果
     */
    public static String singlePushAlias(String[] alias, MessageTemplate messageTemplate, String token) {
        Map<String, Object> map = convertBeanToMap(alias, messageTemplate);
        //请求url
        String url = GE_TUI_BASE_URL + KK_SH_APP_ID + "/push/single/alias";
        log.info("执行别名单推");
        return generalPost(url, token, map);
    }

    /**
     * 创建消息拿到任务id
     *
     * @param messageTemplate 消息模板
     * @param token           token
     * @return 任务id
     */
    public static String getTaskId(MessageTemplate messageTemplate, String token) {
        Map<String, Object> map = convertBeanToMap(null, messageTemplate);
        //请求url
        String url = GE_TUI_BASE_URL + KK_SH_APP_ID + "/push/list/message";
        String body = generalPost(url, token, map);
        JSONObject jsonObject = JSONObject.parseObject(body);
        return (jsonObject.containsKey("code") && jsonObject.getInteger("code") == 0) ? jsonObject.getJSONObject("data").getString("taskid") : body;
    }

    /**
     * 【toList】执行cid批量推
     *
     * @param cid      cid数组
     * @param token    鉴权
     * @param taskId   任务id
     * @param is_async 是否异步
     * @return 执行结果
     */
    public static String listPushCid(String[] cid, String token, String taskId, boolean is_async) {
        String url = GE_TUI_BASE_URL + KK_SH_APP_ID + "/push/list/cid";
        Map<String, Object> cids = new HashMap<>(1);
        cids.put("cid", cid);
        return listPushTaskId(url, token, taskId, is_async, cids);
    }

    /**
     * 【toList】执行别名批量推
     *
     * @param alias    别名
     * @param token    鉴权
     * @param taskId   任务id
     * @param is_async 是否异步
     * @return 执行结果
     */
    public static String listPushAlias(String[] alias, String token, String taskId, boolean is_async) {
        String url = GE_TUI_BASE_URL + KK_SH_APP_ID + "/push/list/alias";
        Map<String, Object> aliass = new HashMap<>(1);
        aliass.put("alias", alias);
        return listPushTaskId(url, token, taskId, is_async, aliass);
    }

    /**
     * 批量推送通用
     *
     * @param url      请求路径
     * @param token    鉴权
     * @param taskId   任务id
     * @param is_async 是否异步
     * @param hashMao  推送目标用户
     * @return 执行结果
     */
    private static String listPushTaskId(String url, String token, String taskId, boolean is_async, Map<String, Object> hashMao) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("audience", hashMao);
        map.put("taskid", taskId);
        map.put("is_async", is_async);
        return generalPost(url, token, map);
    }

    /**
     * 【toApp】执行群推
     *
     * @param messageTemplate 请求参数
     * @param token           token
     * @return 执行结果
     */
    public static String listPushToApp(MessageTemplate messageTemplate, String appId, String token) {
        Map<String, Object> map = convertBeanToMap(null, messageTemplate);
        //请求url
        String url = GE_TUI_BASE_URL + appId + "/push/all";
        log.info("执行群推");
        return generalPost(url, token, map);
    }

    /**
     * 实体类封装为map
     *
     * @param alias           别名
     * @param messageTemplate 消息模板
     * @return map对象
     */
    public static Map<String, Object> convertBeanToMap(String[] alias, MessageTemplate messageTemplate) {
        if (messageTemplate == null) {
            return null;
        }
        //设置推送目标
        messageTemplate.setAudience(new MessageTemplate.Audience(alias));

        //设置请求唯一标识号，10-32位之间；如果request_id重复，会导致消息丢失
        Map<String, Object> map = new HashMap<>();
        map.put("request_id", String.valueOf(IdUtil.getSnowflake(1, 1).nextId()));

        //设置任务组名
        if (StringUtils.isNotBlank(messageTemplate.getGroup_name())) {
            map.put("group_name", messageTemplate.getGroup_name());
        }

        //推送条件设置
        MessageTemplate.Settings settings = messageTemplate.getSettings();
        if (settings != null) {
            Map<String, Object> setting = BeanUtil.beanToMap(settings, false, true);
            Map<String, Object> strategy = new HashMap<>();
            strategy.put("default", 4);
            strategy.put("ios", 4);
            strategy.put("st", 4);
            strategy.put("hw", 4);
            strategy.put("xm", 4);
            strategy.put("vv", 4);
            strategy.put("mz", 4);
            strategy.put("op", 4);
            setting.put("strategy", strategy);
            map.put("settings", setting);
        }

        //推送目标用户该接口audience 对应值为all，表示推送所有用户
        if (alias == null || alias.length == 0) {
            map.put("audience", "all");
        } else {
            Map<String, Object> audience = BeanUtil.beanToMap(messageTemplate.getAudience(), false, true);
            map.put("audience", audience);
        }

        //获取推送消息转为map 不转为下划线,忽略空值
        MessageTemplate.PushMessage push_message = messageTemplate.getPush_message();
        Map<String, Object> push_messages = BeanUtil.beanToMap(push_message, false, true);

        //转换消息忽略空值
        MessageTemplate.PushMessage.Notification notification = push_message.getNotification();
        if (notification != null) {
            //设置消息
            Map<String, Object> notifications = BeanUtil.beanToMap(notification, false, true);
            push_messages.put("notification", notifications);
        }

        MessageTemplate.PushMessage.Revoke revoke = push_message.getRevoke();
        if (revoke != null) {
            //设置撤回消息
            Map<String, Object> revokes = BeanUtil.beanToMap(revoke, false, true);
            push_messages.put("revoke", revokes);
        }
        //设置ios厂商通道
        map.put("push_channel", setChannel(notification));
        //设置android厂商通道
        map.put("push_message", push_messages);

        return map;
    }

    /**
     * 设置推送渠道
     *
     * @param notification 消息
     * @return json
     */
    public static cn.hutool.json.JSONObject setChannel(MessageTemplate.PushMessage.Notification notification) {
        Map<String, Object> channel = new HashMap<>();
        //获取ios配置
        channel.put("ios", getIosChannel(notification));
        //获取android配置
        channel.put("android", getAndroidChannel(notification));
        return JSONUtil.parseFromMap(channel);
    }

    /**
     * ios厂商通道消息配置
     *
     * @param notification 消息
     * @return ios配置
     */
    private static Map<String, Object> getIosChannel(MessageTemplate.PushMessage.Notification notification) {
        Map<String, Object> ios = new HashMap<>();
        ios.put("type", "notify");
        //推送通知消息内容
        Map<String, Object> aps = new HashMap<>();
        aps.put("content-available", 0);

        //通知消息
        Map<String, Object> alert = new HashMap<>();
        alert.put("title", notification.getTitle());
        alert.put("body", notification.getBody());
        aps.put("alert", alert);

        ios.put("aps", aps);
        return ios;
    }

    /**
     * 安卓厂商通道消息配置
     *
     * @param notification 消息
     * @return android配置
     */
    private static Map<String, Object> getAndroidChannel(MessageTemplate.PushMessage.Notification notification) {
        Map<String, Object> android = new HashMap<>();
        //android厂商通道推送消息内容
        Map<String, Object> ups = new HashMap<>();
        //通知消息内容，与transmission、revoke三选一，都填写时报错。若希望客户端离线时，直接在系统通知栏中展示通知栏消息，推荐使用此参数。
        Map<String, Object> informAndroid = new HashMap<>();
        informAndroid.put("title", notification.getTitle());
        informAndroid.put("body", notification.getBody());
        informAndroid.put("click_type", notification.getClick_type());
        informAndroid.put("url", notification.getUrl());
        ups.put("notification", informAndroid);

        android.put("ups", ups);
        return android;
    }

    /**
     * post请求通用
     *
     * @param url   请求路径
     * @param token 鉴权
     * @param map   请求体参数
     * @return 结果
     */
    public static String generalPost(String url, String token, Map<String, Object> map) {
        HttpRequest post = HttpRequest.post(url);
        //设置请求头token
        post.header("token", token);
        post.header("Content-Type", CONTENT_TYPE);
        return post.body(JSONUtil.toJsonStr(map)).execute().body();
    }
}
