package com.weface.component;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class GeTuiPush {

    private static Logger logger = LoggerFactory.getLogger(GeTuiPush.class);

    @Value("config.getui.appkey")
    private String appkey;

    @Value("config.getui.mastersecret")
    private String mastersecret;

    @Value("config.getui.appId")
    private String appId;

    @Value("config.getui.baseUrl")
    private String baseUrl;

    public String token() {
        Map<String, Object> param = new HashMap<>();
        long timestamp = System.currentTimeMillis();
        param.put("appkey", appkey);
        param.put("timestamp", timestamp);
        param.put("sign", getSHA256(appkey + timestamp + mastersecret));
        String res = HttpUtil.post(baseUrl + "/auth", JSONUtil.toJsonStr(param));
        JSONObject jsonObject = new JSONObject(res);
        JSONObject data = jsonObject.getJSONObject("data");
        return data.getStr("token");
    }

    public void toSinglePush(String alia) {
        Map<String, Object> param = new HashMap<>();
        param.put("request_id", String.valueOf(IdUtil.createSnowflake(1, 1).nextId()));
        Map<String, Object> audience = new HashMap<>();
        List<String> alias = new ArrayList<>();
        alias.add(alia);
        audience.put("alias", alias);

        String msg = "测试";

        param.put("audience", JSONUtil.parseFromMap(audience));
        param.put("settings", setSetting());
        param.put("push_message", setMessage(msg));
        param.put("push_channel", setChannel(msg));
        String token = token();
        logger.info("token:{}", token);
        logger.info("请求参数:{}", JSONUtil.toJsonStr(param));
        HttpResponse res =
                HttpUtil.createPost(baseUrl + "/push/single/alias")
                        .body(JSONUtil.toJsonStr(param))
                        .header("token", token)
                        .header("Content-Type", "application/json;charset=utf-8")
                        .execute();
        logger.info("返回:{}", res.body());
    }

    public void toSingleBatchPush(String alia) {
        Map<String, Object> param = new HashMap<>();
        param.put("request_id", String.valueOf(IdUtil.createSnowflake(1,1).nextId()));
        Map<String, Object> audience = new HashMap<>();
        List<String> alias = new ArrayList<>();
        alias.add(alia);
        audience.put("alias", alias);

        String msg = "测试";

        param.put("audience", JSONUtil.parseFromMap(audience));
        param.put("settings", setSetting());
        param.put("push_message", setMessage(msg));
        param.put("push_channel", setChannel(msg));
        String token = token();
        logger.info("token:{}", token);
        logger.info("请求参数:{}", JSONUtil.toJsonStr(param));
        HttpResponse res =
                HttpUtil.createPost(baseUrl + "/push/single/batch/alias")
                        .body(JSONUtil.toJsonStr(param))
                        .header("token", token)
                        .header("Content-Type", "application/json;charset=utf-8")
                        .execute();
        logger.info("返回:{}", res.body());
    }

    public JSONObject setSetting() {
        Map<String, Object> settings = new HashMap();
        settings.put("ttl", -1); // 不离线
        Map<String, Object> strategy = new HashMap<>();
        strategy.put("default", 1);
        strategy.put("ios", 4);
        strategy.put("st", 4);

        settings.put("strategy", JSONUtil.parseFromMap(strategy));
        return JSONUtil.parseFromMap(settings);
    }

    // 定义消息
    public JSONObject setMessage(String msg) {
        Map<String, Object> message = new HashMap();
        Map<String, Object> notification = new HashMap();
        notification.put("title", "标题测试");
        notification.put("body", "内容测试");
        notification.put("click_type", "none");
        notification.put("channel_level", 4);
        message.put("notification", notification);
        // message.put("transmission",msg);
        return JSONUtil.parseFromMap(message);
    }

    public JSONObject setChannel(String msg) {
        Map<String, Object> channel = new HashMap();
        Map<String, Object> ios = new HashMap<>();
        Map<String, Object> aps = new HashMap<>();
        aps.put("content-available", 0);
        Map<String, Object> alert = new HashMap<>();
        alert.put("title", "ios标题");
        alert.put("body", "ios内容");
        aps.put("alert", JSONUtil.parseFromMap(alert));
        ios.put("type", "notify");
        ios.put("payload", msg);
        ios.put("aps", JSONUtil.parseFromMap(aps));
        channel.put("ios", JSONUtil.parseFromMap(ios));

        Map<String, Object> android = new HashMap<>();
        Map<String, Object> ups = new HashMap<>();
        Map<String, Object> notification = new HashMap<>();
        notification.put("title", "android标题");
        notification.put("body", "android内容");
        notification.put("click_type", "none");

        ups.put("notification", JSONUtil.parseFromMap(notification));
        android.put("ups", JSONUtil.parseFromMap(ups));
        channel.put("android", JSONUtil.parseFromMap(android));
        return JSONUtil.parseFromMap(channel);
    }

    public String getSHA256(String str) {
        MessageDigest messageDigest;
        String encodestr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = byte2Hex(messageDigest.digest());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    /**
     * 将byte转为16进制
     *
     * @param bytes
     * @return
     */
    private String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; i++) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                // 1得到一位的进行补0操作
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }
}
