package com.weface.controller;

import com.weface.common.utils.Model;
import com.weface.common.utils.PageUtils;
import com.weface.dto.UserTagFrom;
import com.weface.service.UserTagService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


/**
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@RestController
@RequestMapping("/tags/userTags")
public class UserTagsController {
    @Autowired
    private UserTagService tUserTagService;

    /**
     * 查询所有用户对应标签信息
     */
    @PostMapping("/list")
    public Model list(@RequestBody Map<String, Object> params) {
        PageUtils page = tUserTagService.getUserAndTags(params);
        return Model.ok(page);
    }

    /**
     * 根据标签查询用户gid
     */
    @PostMapping("/queryByTag")
    public Model queryByTag(@RequestBody UserTagFrom userTagFrom) {
        List<String> data = tUserTagService.getGidByTag(userTagFrom.getTags());
        return Model.ok(data);
    }

    /**
     * 根据gid查询用户标签
     */
    @PostMapping("/queryByGid")
    public Model queryByGid(@RequestBody UserTagFrom userTagFrom) {
        String gid = userTagFrom.getGiUidList()[0];
        if (StringUtils.isBlank(gid)) {
            return Model.error("gid不能为空");
        }
        Map<String, Object> data = tUserTagService.getTagByGid(gid);
        return Model.ok(data);
    }

}
