package com.weface.common.utils;

import lombok.Getter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Aleyn
 * @since 2021/11/10 16:34
 */
@Getter
public class Model<T> implements Serializable {
    private String code;

    private String msg;

    private T data;

    public static final String SUCCESS = "0000";
    public static final String ERROR = "500";

    public Model<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public Model<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Model<T> setData(T data) {
        this.data = data;
        return this;
    }

    public static <T> Model ok() {
        return new Model().setCode(SUCCESS).setMsg("请求成功");
    }

    public static <T> Model ok(T result) {
        return new Model().setCode(SUCCESS).setMsg("请求成功").setData(result);
    }

    public static Model ok(String msg) {
        return new Model().setCode(SUCCESS).setMsg(msg);
    }

    public static Model error(Integer code, String msg) {
        return new Model().setCode(code.toString()).setMsg(msg);
    }

    public static Model error(String msg) {
        return new Model().setCode(ERROR).setMsg(msg);
    }

    public static Model error() {
        return new Model().setCode(ERROR).setMsg("未知异常，请联系管理员");
    }

    public Model put(String k, Object v) {
        Map<String, Object> map = new HashMap<>();
        map.put(k, v);
        this.data = (T) map;
        return this;
    }


}
