package com.weface.common.validator;

import com.weface.code.CommonResult;
import com.weface.code.ResultCode;
import com.weface.dto.InformForm;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author : Administrator
 * @date : 2022/4/21 14:28
 */
public class ValidatorParam {


    public static CommonResult validPushSingleAlias(InformForm informForm) {
        Integer pushType = informForm.getPushType();
        if (pushType != null && pushType == 1) {
            String className = informForm.getClassName();
            String classTitle = informForm.getClassTitle();
            String needLogin = informForm.getNeedLogin();
            if (StringUtils.isEmpty(className) || StringUtils.isEmpty(classTitle) || StringUtils.isEmpty(needLogin)) {
                return CommonResult.failed(ResultCode.PARAMS_ERROR);
            }
        }
        String[] cid = informForm.getCid();
        String phone = informForm.getPhone();
        Integer messageTemplate = informForm.getMessageTemplate();
        if (ArrayUtils.isEmpty(cid) || StringUtils.isEmpty(phone) || messageTemplate == null) {
            return CommonResult.failed(ResultCode.PARAMS_ERROR);
        }
        return null;
    }

}
