package com.weface;


import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HtmlUtil;
import com.weface.code.CommonResult;
import com.weface.component.GeTuiUtils;
import com.weface.component.MenuService;
import com.weface.component.MessageTemplate;
import com.weface.dto.InformForm;
import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserTagEntity;
import com.weface.entity.UserMenusEntity;
import com.weface.service.MenuTagsService;
import com.weface.service.UserTagService;
import com.weface.service.UserMenusService;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

@SpringBootTest
class PushMessageApplicationTests {
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private UserMenusService userMenusService;
    @Autowired
    private MenuTagsService menuTagsService;

    @Test
    void contextLoads() {
    }

    /**
     * 根据时间同步标签
     */
    @Test
    public void testKKSB() {
        try {
            //77164
            //已处理0
            //每次处理总条数 20000
            int star = 10000;
            int end = 30000;
            List<MenuTagsEntity> tags = menuTagsService.list();
            List<UserTagEntity> todayUser = userTagService.findNoTagUser(star, end);
            List<String> todayGid = todayUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
            int size = todayGid.size();
            int limit = 1000;
            List<UserMenusEntity> userMenusList = new ArrayList<>();
            int totalPage = (size % limit == 0) ? (size / limit) : (size / limit + 1);
            CountDownLatch latch = new CountDownLatch(totalPage);
            ExecutorService pool = Executors.newFixedThreadPool(totalPage);
            //收集中间表数据
            for (int i = 0; i < totalPage; i++) {
                int finalI = i;
                Runnable runnable = () -> {
                    List<String> list;
                    if (finalI == totalPage - 1) {
                        list = todayGid.subList(finalI * limit, size);
                    } else {
                        list = todayGid.subList(finalI * limit, (finalI + 1) * limit);
                    }
                    if (CollectionUtils.isNotEmpty(list)) {
                        Map<String, Object> android = menuService.getUserTags(list, tags);
                        List<UserMenusEntity> tagUser = menuService.getTagUser(android, todayUser);
                        if (CollectionUtils.isNotEmpty(tagUser)) {
                            userMenusList.addAll(tagUser);
                        }
                    }
                    latch.countDown();
                };
                pool.execute(runnable);
            }
            latch.await();
            userMenusService.batchInsert(userMenusList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testListPush() {
        InformForm informForm = new InformForm();
        informForm.setTitle("河南一名小学生确诊阳性！");
        informForm.setBody("1月23日新增一例本土确诊病例！为11岁小学生");
        informForm.setUrl("https://kk.weface.com.cn/news/page/?id=c0933d0e2fc85f7333b6202dff0e611c&type=hot&from=101");
        informForm.setPush_type("0");
        informForm.setEquipmentType("kksh");
        CommonResult commonResult = GeTuiUtils.listPush(informForm);
        System.out.println(commonResult);
    }

    @Test
    void testConventTemplate() throws UnsupportedEncodingException {
        InformForm informForm = new InformForm();

        String[] alias = {"kksh_10131492"};
//        String[] alias = {"kksh_59354"};

//        String token = GeTuiUtils.getAuthToken("kk_sh_token_ge_tui");
        String token = GeTuiUtils.getAuthToken("kk_sb_token_ge_tui");

        informForm.setTitle("河南一名小学生确诊阳性！");
        informForm.setBody("1月23日新增一例本土确诊病例！为11岁小学生");
        informForm.setUrl("https://kk.weface.com.cn/news/page/?id=c0933d0e2fc85f7333b6202dff0e611c&type=hot&from=101");

        MessageTemplate messageTemplate = new MessageTemplate();
        messageTemplate.setAudience(new MessageTemplate.Audience(alias));

        messageTemplate.setSettings(new MessageTemplate.Settings(3600000, 0));

        MessageTemplate.PushMessage pushMessage = new MessageTemplate.PushMessage();

        MessageTemplate.PushMessage.Transmission transmission = new MessageTemplate.PushMessage.Transmission();
        transmission.setTitle(informForm.getTitle());
        transmission.setContent(informForm.getBody());
        transmission.setUrl(informForm.getUrl());

        pushMessage.setTransmission(transmission);

        messageTemplate.setPush_message(pushMessage);
//        String s = GeTuiUtils.singlePushAlias(4, messageTemplate, GeTuiUtils.KK_SH_APP_ID, token);
        String s = GeTuiUtils.singlePushAlias(1, messageTemplate, GeTuiUtils.KK_SB_APP_ID, token);
        System.out.println(s);
    }


    @Test
    void testRevoke() {
        Map<String, Object> map = new HashMap<>();
        map.put("request_id", String.valueOf(IdUtil.getSnowflake(1, 1).nextId()));
        map.put("audience", "all");

        Map<String, Object> push_message = new HashMap<>();
        HashMap<String, Object> revoke = new HashMap<>();
        revoke.put("old_task_id", "RASA_0127_011f801354c5236738787cdda86cf232");
        revoke.put("force", false);
        push_message.put("revoke", revoke);
        map.put("push_message", push_message);
        String url = GeTuiUtils.GE_TUI_BASE_URL + GeTuiUtils.KK_SH_APP_ID + "/push/all";
        String kk_sh_token_ge_tui = GeTuiUtils.getAuthToken("kk_sh_token_ge_tui");
        String s = GeTuiUtils.generalPost(url, kk_sh_token_ge_tui, map);
        System.out.println(s);
    }


    @Test
    void testBase() {
        String url = "https://kk.weface.com.cn/news/page/?id=8def012d3485ca0e87455b6c5aeeea18&amp;type=hot&amp;from=101";
        String unescape = HtmlUtil.unescape(url);
        System.out.println(unescape);
    }

}
