package com.weface.config;

import com.weface.common.xss.XssFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.DispatcherType;
import java.util.HashMap;
import java.util.Map;

/**
 * Filter配置
 *
 * @author Mark sunlightcs@gmail.com
 */
@Configuration
public class FilterConfig {

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        FilterRegistrationBean<XssFilter> registration = new FilterRegistrationBean<>();
        registration.setDispatcherTypes(DispatcherType.REQUEST);
        registration.setFilter(new XssFilter());
        registration.addUrlPatterns("/*");
        registration.setName("xssFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    /**
     * 注册 签名校验过滤器
     */
    @Bean
    public FilterRegistrationBean<SignValidateFilter> signValidateFilter() {
        final String include = "/push/single/alias,/push/single/cid";
        //不拦截的url列表
        final String excludes = "";
        //拦截url列表
        FilterRegistrationBean<SignValidateFilter> bean = new FilterRegistrationBean<>();
        bean.setFilter(new SignValidateFilter());
        bean.setName("signValidateFilter");
        //设置拦截的url
        bean.addUrlPatterns(include.split(","));
        //设置不拦截
        Map<String, String> initParameters = new HashMap<>(1);
        initParameters.put("excludes", excludes);
        bean.setInitParameters(initParameters);
        return bean;
    }
}
