package com.weface.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.dto.InformForm;
import com.weface.entity.NavigateConfigEntity;
import com.weface.entity.PushLogEntity;

import java.util.List;

/**
 * @author admin
 * @date 2022-04-20 09:54:09
 */
public interface PushLogService extends IService<PushLogEntity> {

    /**
     * 保存日志 个推
     *
     * @param data       返回数据
     * @param informForm 推送数据
     * @param appId      应用id
     */
    public void saveLog(JSONObject data, InformForm informForm, String appId);

    /**
     * 保存推送日志 袤博
     *
     * @param data       返回数据
     * @param informForm 推送数据
     * @param isBatch 是否为批量推送
     */
    public void saveMobLog(JSONObject data, InformForm informForm, boolean isBatch);

    /**
     * 查询日志
     *
     * @param taskId 任务id
     * @return 日志信息
     */
    public PushLogEntity getPushLog(String taskId);

    /**
     * 查询推送日志
     *
     * @param time 时间
     * @return 推送日志
     */
    public List<PushLogEntity> getPushLogByTime(Integer time);

    /**
     * 以下借助推送日志类查询
     * 获取已缴费用户id
     *
     * @return 用户id列表
     */
    public List<String> getOrderUidList();

    /**
     * 查询当月1-14号记录的用户id
     *
     * @return 未缴费用户id
     */
    public List<String> getPayCostRecord();

    /**
     * 根据配置名称获取配置信息
     *
     * @param configName 配置名称
     * @return 配置信息
     */
    public NavigateConfigEntity getConfigByName(String configName);
}

