package com.weface.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.weface.entity.NavigateConfigEntity;
import com.weface.entity.PushLogEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author admin
 * @date 2022-04-20 09:54:09
 */
@Mapper
public interface PushLogDao extends BaseMapper<PushLogEntity> {

    /**
     * 根据时间查询推送日志
     *
     * @param time 时间
     * @return 推送日志
     */
    List<PushLogEntity> getPushLogByTime(@Param("time") Integer time);

    /**
     * 以下借助推送日志类查询
     * 获取已缴费用户id
     *
     * @return 用户id列表
     */
    List<String> getOrderUidList();

    /**
     * 查询当月1-14号没有交费记录的用户id
     *
     * @return 未缴费用户id
     */
    List<String> getPayCostRecord();

    /**
     * 根据配置名称获取配置信息 并缓存30分钟
     *
     * @param configName 配置名称
     * @return 配置信息
     */
    List<NavigateConfigEntity> getConfigByName(@Param("configName") String configName);
}
