package com.weface.common.utils;


import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

/**
 * http 工具类
 */
@Slf4j
public class HttpUtil {

    public static String post(String requestUrl, String accessToken, String params) throws Exception {
        String contentType = "application/x-www-form-urlencoded";
        return HttpUtil.post(requestUrl, accessToken, contentType, params);
    }

    public static String post(String requestUrl, String accessToken, String contentType, String params) throws Exception {
        String encoding = "UTF-8";
        if (requestUrl.contains("nlp")) {
            encoding = "GBK";
        }
        return HttpUtil.post(requestUrl, accessToken, contentType, params, encoding);
    }

    public static String post(String requestUrl, String accessToken, String contentType, String params, String encoding) throws Exception {
        String url = requestUrl + "?access_token=" + accessToken;
        return HttpUtil.postGeneralUrl(url, contentType, params, encoding);
    }

    public static String postGeneralUrl(String generalUrl, String contentType, String params, String encoding) throws Exception {
        return HttpUtil.postGeneralUrl(generalUrl, contentType, params, encoding, null);
    }

    public static String postGeneralUrl(String generalUrl, String contentType, String params, String encoding, String token) throws Exception {
        URL url = new URL(generalUrl);
        // 打开和URL之间的连接
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setRequestMethod("POST");
        // 设置通用的请求属性
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("Connection", "Keep-Alive");
        if (StringUtils.isNotEmpty(token)) {
            connection.setRequestProperty("token", token);
        }
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        // 得到请求的输出流对象
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.write(params.getBytes(StandardCharsets.UTF_8));
        out.flush();
        out.close();

        // 建立实际的连接
        connection.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
        StringBuilder result = new StringBuilder();
        String getLine;
        while ((getLine = in.readLine()) != null) {
            result.append(getLine);
        }
        in.close();
        return result.toString();
    }

    public static boolean isJson2(String str) {
        boolean flag = false;
        try {
            Object parse = JSON.parse(str);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 从请求中拿到请求流数据
     *
     * @param request 请求
     * @return 字节数组
     * @throws IOException io异常
     */
    public static byte[] getRequestInputStream(HttpServletRequest request) throws IOException {
        ServletInputStream input = request.getInputStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int position = 0;
        while (true) {
            position = input.read(buffer);
            if (position == -1) {
                break;
            }
            output.write(buffer, 0, position);
        }
        return output.toByteArray();

    }
}
