package com.weface.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.code.CommonResult;
import com.weface.dto.MenuTagsForm;
import com.weface.entity.MenuTagsEntity;

import java.util.List;

/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
public interface MenuTagsService extends IService<MenuTagsEntity> {

    /**
     * 列表
     *
     * @return 标签数据
     */
    List<Object> getTagsList();

    /**
     * 增加标签
     *
     * @param menuTagsForm 数据
     * @return 执行结果
     */
    CommonResult saveTag(MenuTagsForm menuTagsForm);

    /**
     * 修改标签
     *
     * @param menuTagsForm 数据
     * @return 执行结果
     */
    CommonResult updateTag(MenuTagsForm menuTagsForm);
}

