package com.weface.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: lyg
 * @Description:
 * @Date: 2023/5/10 16:03
 **/
@Data
public class MultiInformForm {

    /**
     * 推送的消息体数组
     */
    @NotEmpty(message = "消息列表不能为空")
    private List<MultiMsgDTO> msgList;

    /**
     * 跳转url
     */
    @NotBlank(message = "url不能为空")
    private String url;

    /**
     * 推送类型 0:h5 1:原生，默认h5
     */
    @NotNull(message = "pushType不能为空")
    private Integer pushType;

    /**
     * 推送平台：kksh,kksb,kkwj,kkmz
     */
    @NotBlank(message = "equipmentType不能为空")
    private String equipmentType;

}
