package com.weface.controller;


import com.weface.code.CommonResult;
import com.weface.common.validator.ValidatorUtils;
import com.weface.dto.MenuTagsForm;
import com.weface.service.MenuTagsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@RestController
@RequestMapping("/sys/menu")
public class MenuTagsController {
    @Autowired
    private MenuTagsService menuTagsService;

    /**
     * 标签列表 可模糊查询根据levelThird
     */
    @PostMapping("/list_menu")
    public CommonResult list() {
        List<Object> data = menuTagsService.getTagsList();
        return CommonResult.success(data);
    }

    /**
     * 新增标签
     */
    @PostMapping("/save_menu")
    public CommonResult save(@RequestBody MenuTagsForm menuTagsForm) {
        ValidatorUtils.validateEntity(menuTagsForm, MenuTagsForm.SaveTag.class);
        return menuTagsService.saveTag(menuTagsForm);
    }

    /**
     * 修改标签
     */
    @PostMapping("/update_menu")
    public CommonResult update(@RequestBody MenuTagsForm menuTagsForm) {
        ValidatorUtils.validateEntity(menuTagsForm, MenuTagsForm.UpdateTag.class);
        return menuTagsService.updateTag(menuTagsForm);
    }

    /**
     * 删除标签
     */
    @PostMapping("/del_menu")
    public CommonResult del(@RequestBody MenuTagsForm menuTagsForm) {
        ValidatorUtils.validateEntity(menuTagsForm, MenuTagsForm.UpdateTag.class);
        menuTagsService.removeById(menuTagsForm.getId());
        return CommonResult.success(null);
    }
}
