package com.weface.common.validator;

import com.weface.code.CommonResult;
import com.weface.code.ResultCode;
import com.weface.dto.InformForm;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author : Administrator
 * @date : 2022/4/21 14:28
 */
public class ValidatorParam {

    /**
     * 校验推送参数
     *
     * @param informForm 推送参数
     * @return 核验结果
     */
    public static CommonResult validPushParams(InformForm informForm) {
        Integer style = informForm.getStyle();
        if (Objects.nonNull(style)) {
            if (style == 1 || style == 2) {
                String content = informForm.getContent();
                if (StringUtils.isEmpty(content)) {
                    return CommonResult.failed(ResultCode.PARAMS_ERROR);
                }
            }
        }
        return null;
    }

    /**
     * 核验别名单推推送参数
     *
     * @param informForm 推送参数
     * @return 核验结果
     */
    public static CommonResult validPushSingleAlias(InformForm informForm) {
        String body = informForm.getBody();
        if (body.length() > 60) {
            return CommonResult.failed(ResultCode.CONTENT_MORE_LENGTH);
        }
        Integer pushType = informForm.getPushType();
        if (pushType != null && pushType == 1) {
            String className = informForm.getClassName();
            String classTitle = informForm.getClassTitle();
            String needLogin = informForm.getNeedLogin();
            if (StringUtils.isEmpty(className) || StringUtils.isEmpty(classTitle) || StringUtils.isEmpty(needLogin)) {
                return CommonResult.failed(ResultCode.PARAMS_ERROR);
            }
        }
        String cid = informForm.getCid();
        String phone = informForm.getPhone();
        Integer messageTemplate = informForm.getMessageTemplate();
        if (StringUtils.isEmpty(cid) || StringUtils.isEmpty(phone) || messageTemplate == null) {
            return CommonResult.failed(ResultCode.PARAMS_ERROR);
        }
        return null;
    }

}
