package com.weface.common.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

/**
 * @author Administrator
 */
public class DES {

    private byte[] desKey;

    public DES(String desKey) {
        this.desKey = desKey.getBytes();
    }

    private static DES des;

    private DES() {

    }

    public static DES getInstanceDes() {
        if (ObjectUtil.isNull(des)) {
            des = new DES(Constant.DES_KEY);
        }
        return des;
    }


    /**
     * 加密
     *
     * @param plainText 原文
     * @return 密文
     * @throws Exception 异常
     */
    public byte[] desEncrypt(byte[] plainText) throws Exception {
        SecureRandom sr = new SecureRandom();
        byte[] rawKeyData = desKey;
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        javax.crypto.SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key, sr);
        return cipher.doFinal(plainText);
    }

    /**
     * 解密
     *
     * @param encryptText 密文
     * @return 原文
     * @throws Exception 异常
     */
    public byte[] desDecrypt(byte[] encryptText) throws Exception {
        SecureRandom sr = new SecureRandom();
        byte[] rawKeyData = desKey;
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        javax.crypto.SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key, sr);
        return cipher.doFinal(encryptText);
    }

    /**
     * 加密
     *
     * @param input 原文
     * @return 加密后数据
     * @throws Exception 异常
     */
    public String encrypt(String input) throws Exception {
        if (StringUtils.isEmpty(input)) {
            return null;
        }
        return Base64.encode(desEncrypt(input.getBytes(StandardCharsets.UTF_8)));
    }

    /**
     * 解密
     *
     * @param input 加密数据
     * @return 原文
     */
    public String decrypt(String input) {
        if (StringUtils.isEmpty(input)) {
            return null;
        }
        byte[] result = Base64.decode(input);
        try {
            if (CommonUtil.isBase64(input)) {
                return new String(desDecrypt(result), StandardCharsets.UTF_8);
            } else {
                return input;
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String encrypt2(String input) throws Exception {
        return new String(desEncrypt(input.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String decrypt2(String input) throws Exception {
        return new String(desDecrypt(input.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }


    public static void main(String[] args) {
        DES des = new DES(Constant.DES_KEY);
        String name = des.decrypt("mC8HL+gBKJs=");
        String head = des.decrypt("JH2AUKTuP4k4065YeoNoDA==");
        System.out.println(name);
        System.out.println(head);
    }
}
