package com.weface.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 所有标签等级划分
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@Data
@TableName("tb_menu_tags")
public class MenuTagsEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;
    /**
     * 一级标签名称
     */
    @Excel(name = "一级标签", width = 10)
    private String levelFirst;
    /**
     * 二级标签名称
     */
    @Excel(name = "二级标签", width = 10)
    private String levelSecond;
    /**
     * 三级标签名称
     */
    @Excel(name = "三级标签", width = 10)
    private String levelThird;
    /**
     * 编码
     */
    private String code;
    /**
     * 套餐等级
     */
    private Integer menuGrade;
    /**
     * 是否有权重
     */
    private String weight;
    /**
     * 是否删除
     */
    private Integer isDel;
    /**
     *
     */
    private Date createTime;
    /**
     *
     */
    private Date updateTime;

}
