package com.weface.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 
 * @author admin
 * @date 2022-04-20 09:54:09
 */
@Data
@TableName("tb_push_call_back")
public class PushCallBackEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 应用 ID
	 */
	private String appid;
	/**
	 * 接收人CID
	 */
	private String cid;
	/**
	 * 任务 ID（即 ContentID）
	 */
	private String taskid;
	/**
	 * 消息 ID
	 */
	private String msgid;
	/**
	 * 结果码(200 -- 成功，400 -- 推送苹果接口失败， 401 -- 用户不存在，402 -- 非活跃用户，500 -- 系统内部异常)目前只有 200 和 400，后续版本扩展。
	 */
	private String code;
	/**
	 * 推送结果描述
	 */
	private String descStr;
	/**
	 * 签名
	 */
	private String sign;
	/**
	 * 回执 ID
	 */
	private String actionid;
	/**
	 * 回执上传时间
	 */
	private Long recvtime;
	/**
	 * 根据配置返回
	 */
	private String alias;
	/**
	 * 状态
	 */
	private Integer status;
	/**
	 * 是否删除 1:未删除 0 :删除
	 */
	@TableLogic(value = "1", delval = "0")
	@TableField(fill = FieldFill.INSERT)
	private Integer isValid;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 更新时间
	 */
	private Date updateTime;

}
