package com.weface.config;


import java.io.Serializable;

/**
 * @author : Administrator
 * @date : 2022/4/21 10:58
 */

public class RedisExpireData implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object storeData;
    private Long expire;
    private Long dataTime;

    public RedisExpireData(Object data, Long expire) {
        this.storeData = data;
        this.expire = expire;
        this.dataTime = System.currentTimeMillis();
    }

    /**
     * 获取对应的expire数据
     *
     * @return java.lang.String
     */
    public Object getStoreData() {
        Long curr = System.currentTimeMillis();
        if (curr - this.dataTime > this.expire) {
            return null;
        } else {
            return this.storeData;
        }
    }

    public void setStoreData(Object storeData) {
        this.storeData = storeData;
    }

    public Long getExpire() {
        return expire;
    }

    public void setExpire(Long expire) {
        this.expire = expire;
    }

    public Long getDataTime() {
        return dataTime;
    }

    public void setDataTime(Long dataTime) {
        this.dataTime = dataTime;
    }
}
