package com.weface.component;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.weface.code.CommonResult;
import com.weface.common.utils.Constant;
import com.weface.common.utils.Model;
import com.weface.dto.InformForm;
import com.weface.service.PushLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Type;
import java.util.*;

/**
 * @author : Administrator
 * @date : 2022/5/30 17:49
 * mob 推送
 */
@Component
@Slf4j
public class MobPushService {
    /**
     * mob推送key
     */
    private static final String APP_KEY = "3511c2579cad6";
    /**
     * mob推送密钥
     */
    private static final String APP_SECRET = "f446a56b98aae09beb5721ebdbe0d2e8";

    @Autowired
    private PushLogService pushLogService;

    /**
     * mob 推送
     *
     * @param informForm 推送信息
     * @param target     推送目标类型
     * @return 执行结果
     */
    public CommonResult mobPush(InformForm informForm, Constant.PushTarget target) {
        String pushUrl = "http://api.push.mob.com/v3/push/createPush";
        Map<String, Object> request = new HashMap<>();
        //枚举值 webapi
        request.put("source", "webapi");
        //自定义任务id（用户自自定义生成且唯一、不能重复）
        request.put("workno", IdUtil.fastUUID());
        //appkey
        request.put("appkey", APP_KEY);
        informForm.setUrl(HtmlUtil.unescape(informForm.getUrl()));
        String[] split = new String[0];
        if (target.getKey() != 1) {
            //推送目标
            String cid = informForm.getCid();
            if (cid.contains(",")) {
                split = cid.split(",");
            } else {
                split = new String[]{cid};
            }
        }
        Map<String, Object> pushTarget = getPushTarget(target.getKey(), split);
        request.put("pushTarget", pushTarget);

        //推送展示细节配置
        Map<String, Object> pushNotify = getPushNotify(informForm);
        request.put("pushNotify", pushNotify);
        Map<String, Object> pushForward = getPushForward();
        request.put("pushForward", pushForward);
        //厂商特殊配置
        Map<String, Object> pushFactoryExtra = getPushFactoryExtra();
        request.put("pushFactoryExtra", pushFactoryExtra);
        //groupId: AB分组测试ID
        request.put("groupId", target.getValue());
        String body = generalPost(request, pushUrl);
        if (body != null) {
            pushLogService.saveMobLog(JSONObject.parseObject(body), informForm);
            return CommonResult.success();
        }
        return null;
    }

    /**
     * 厂商特殊渠道配置
     *
     * @return map
     */
    private Map<String, Object> getPushFactoryExtra() {
        Map<String, Object> pushFactoryExtra = new HashMap<>();
        Map<String, Object> huaweiExtra = new HashMap<>();
        huaweiExtra.put("importance", "NORMAL");
        pushFactoryExtra.put("huaweiExtra", huaweiExtra);
        Map<String, Object> vivoExtra = new HashMap<>();
        vivoExtra.put("classification", "1");
        pushFactoryExtra.put("vivoExtra", vivoExtra);
        return pushFactoryExtra;
    }

    /**
     * mob批量推送
     *
     * @param informForm 推送内容
     * @param target     推送目标
     * @return 执行结果
     */
    public Model batchMobPush(InformForm informForm, Constant.PushTarget target) {
        String pushUrl = "http://api.push.mob.com/v3/push/createMulti";
        Map<String, Object> request = new HashMap<>(2);

        Map<String, Object> pushWork = new HashMap<>();
        //枚举值 webapi
        pushWork.put("source", "webapi");
        //Mob-appkey
        pushWork.put("appkey", APP_KEY);
        //推送展示细节配置
        Map<String, Object> pushNotify = getBatchPushNotify(informForm);
        pushWork.put("pushNotify", pushNotify);
        //link 相关打开配置
        Map<String, Object> pushForward = getPushForward();
        pushWork.put("pushForward", pushForward);
        //是否重复推送
        //pushWork.put("repate", repate);
        //repate 重复记录原始ID
        //pushWork.put("parentId", parentId);
        //groupId: AB分组测试ID
        pushWork.put("groupId", target.getValue());
        request.put("pushWork", pushWork);
        //推送目标
        String[] split;
        String cid = informForm.getCid();
        if (cid.contains(",")) {
            split = cid.split(",");
        } else {
            split = new String[]{cid};
        }
        Map<String, Object> items = getItems(split, informForm.getTitle(), informForm.getBody(), target.getKey());
        request.put("items", new Object[]{items});
        String body = generalPost(request, pushUrl);
        log.info("批量推送结果:{}", body);
        if (body != null) {
            return Model.ok();
        }
        return Model.error();
    }


    public boolean getPushInfoById(String workId) {
        String reqUrl = "http://api.push.mob.com/v3/stats/getByWorkId";
        Map<String, Object> request = new HashMap<>();
        //appkey
        request.put("appkey", APP_KEY);
        request.put("workId", workId);
        String body = generalPost(request, reqUrl);
        log.error("查询回调结果:{}", body);
        if (JSONUtil.isJson(body)) {
            JSONObject json = JSONObject.parseObject(body);
            if (json.containsKey("status") && json.getInteger("status").equals(200)) {
                if (json.containsKey("res")) {
                    JSONObject res = json.getJSONObject("res");
                    if (Objects.nonNull(res)) {
                        if (res.containsKey("android")) {
                            JSONObject android = res.getJSONObject("android");
                            if (Objects.nonNull(android)) {
                                if (android.containsKey("deliverFailNum")) {
                                    Integer deliverFailNum = android.getInteger("deliverFailNum");
                                    return deliverFailNum <= 0;
                                }
                            }
                        } else if (res.containsKey("ios")) {
                            JSONObject ios = res.getJSONObject("ios");
                            if (Objects.nonNull(ios)) {
                                if (ios.containsKey("deliverFailNum")) {
                                    Integer deliverFailNum = ios.getInteger("deliverFailNum");
                                    return deliverFailNum <= 0;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private Map<String, Object> getItems(String[] target, String title, String content, Integer pushType) {
        Map<String, Object> items = new HashMap<>();
        items.put("itemId", IdUtil.fastUUID());
        //items.put("workNo", workNo);
        //items.put("appPackages", new String[]{});
        if (pushType.equals(Constant.PushTarget.ALIAS.getKey())) {
            items.put("alias", target);
        }
        if (pushType.equals(Constant.PushTarget.RIDS.getKey())) {
            items.put("rids", target);
        }
        items.put("title", title);
        items.put("content", content);
        return items;
    }

    /**
     * 批量推送
     *
     * @param informForm 推送信息
     * @return 执行结果
     */
    private Map<String, Object> getBatchPushNotify(InformForm informForm) {
        //推送展示细节配置
        Map<String, Object> pushNotify = new HashMap<>(8);
        //1 android;2 ios
        pushNotify.put("plats", new Integer[]{1, 2});
        //推送类型：1通知；2自定义
        pushNotify.put("type", 1);
        //android通知消息, type=1, android
        Map<String, Object> androidNotify = getAndroidNotify();
        if (!androidNotify.isEmpty()) {
            pushNotify.put("androidNotify", androidNotify);
        }
        //ios通知消息, type=1, ios
        Map<String, Object> iosNotify = getIosNotify();
        if (!iosNotify.isEmpty()) {
            pushNotify.put("iosNotify", iosNotify);
        }
        if (informForm.getSpeed() != null) {
            pushNotify.put("speed", informForm.getSpeed());
        }
        //推送时，不走厂商通道。1: 开启，不走厂商通道；其它，关闭 ，默认关闭。
        pushNotify.put("skipFactory", 0);
        //推送策略： * 1:先走tcp，再走厂商 * 2:先走厂商，再走tcp * 3:只走厂商 * 4:只走tcp (厂商透传policy只支持策略3或4)
        pushNotify.put("policy", 2);
        //拓展参数
        pushNotify.put("extrasMapList", getExtrasMapList(informForm));
        return pushNotify;
    }

    /**
     * 获取推送目标
     *
     * @param type   推送类型
     * @param target 推送目标
     * @return 推送目标配置
     */
    private Map<String, Object> getPushTarget(Integer type, Object target) {
        //推送目标
        Map<String, Object> pushTarget = new HashMap<>(2);
        //目标类型：1广播；2别名；3标签；4regid；5地理位置；6用户分群；9复杂地理位置推送；14fileid推送
        pushTarget.put("target", type);
        //集合元素限制1000个以内
        if (target instanceof String[]) {
            String[] str = (String[]) target;
            if (str.length > 1000) {
                return null;
            }
        }
        //推送目标
        switch (type) {
            case 1:
                //target:1 => 1广播
                break;
            case 2:
                //arget:2 => 设置推送别名集合["alias1","alias2"]集合元素限制1000个以内
                pushTarget.put("alias", target);
                break;
            case 3:
                //target:3 => 设置推送标签集合["tag1","tag2"]集合元素限制1000个以内
                pushTarget.put("tags", target);
                //target:3 => 标签组合方式：1并集；2交集；3补集(3暂不考虑)
                pushTarget.put("tagsType", 1);
                break;
            case 4:
                //target:4 => 设置推送Registration Id集合["id1","id2"]集合元素限制1000个以内
                pushTarget.put("rids", target);
                break;
            case 5:
                //target:5 => 推送地理位置 城市，地理位置推送时（示例：上海市注意要带“市”），city, province, country 必须有一个不为空
                /*if (str.length > 0) {
                    pushTarget.put("province", str[0]);
                }
                if (str.length > 1) {
                    pushTarget.put("city", str[1]);
                }
                if (str.length > 2) {
                    pushTarget.put("country", str[2]);
                }*/
                if (target instanceof Map) {
                    Map<String, String> address = Convert.convert(new TypeReference<Map<String, String>>() {
                        @Override
                        public Type getType() {
                            return super.getType();
                        }
                    }, target);
                    pushTarget.putAll(address);
                }
                break;
            case 6:
                pushTarget.put("block", target);
                break;
            case 9:
                pushTarget.put("pushAreas", target);
                break;
            case 14:
                pushTarget.put("fileId", target);
                break;
            default:
                break;
        }
        return pushTarget;
    }

    /**
     * 推送展示细节配置
     *
     * @param informForm 推送内容细节
     * @return 推送展示配置
     */
    private Map<String, Object> getPushNotify(InformForm informForm) {
        Map<String, Object> pushNotify = getBatchPushNotify(informForm);
        //推送内容, 如果内容长度超过厂商的限制, 则内容会被截断. vivo不允许纯表情
        pushNotify.put("content", informForm.getBody());
        //如果不设置，则默认的通知标题为应用的名称。如果标题长度超过厂商的限制, 则标题会被截断. vivo不允许纯表情
        pushNotify.put("title", informForm.getTitle());
        return pushNotify;
    }

    /**
     * link 相关打开配置 目前默认打开首页
     *
     * @return 消息跳转地址配置
     */
    private Map<String, Object> getPushForward() {
        Map<String, Object> pushForward = new HashMap<>(1);
        pushForward.put("nextType", 0);
        return pushForward;
    }

    /**
     * 链接跳转地址配置
     *
     * @param informForm 推送信息
     * @return 跳转地址配置
     */
    private List<Map<String, Object>> getExtrasMapList(InformForm informForm) {
//        String pack = "com.weface.kksocialsecurity";
//        String component = pack + "/com.weface.kksocialsecurity.activity.WellcomeActivity";
        Integer pushType = informForm.getPushType();
        int push;
        if (pushType == null || pushType == 0) {
            push = 0;
        } else {
            push = 2;
        }
        List<Map<String, Object>> list = new ArrayList<>(2);
        //设置包名
//        list.add(getFiled("package", pack));
        //设置路径
//        list.add(getFiled("component", component));
        //推送内容
//        list.add(getFiled("content", informForm.getBody()));
        //推送类型 0 h5 2 原生
        list.add(getFiled("push_type", push));
        //推送地址
        list.add(getFiled("url", informForm.getUrl()));
        //推送标题
//        list.add(getFiled("title", informForm.getTitle()));
        return list;
    }

    /**
     * 获取字段
     *
     * @param key   key
     * @param value value
     * @return 字段
     */
    private Map<String, Object> getFiled(String key, Object value) {
        Map<String, Object> map = new HashMap<>(2);
        map.put("key", key);
        map.put("value", value);
        return map;
    }

    /**
     * 安卓通知细节配置
     *
     * @return 安卓细节
     */
    private Map<String, Object> getAndroidNotify() {
        Map<String, Object> androidNotify = new HashMap<>(1);
        androidNotify.put("warn", "123");
        //androidNotify.put("content", new String[]{"测试这是一条数据"});
        //androidNotify.put("style", "3");
        return androidNotify;
    }

    /**
     * ios通知细节配置
     *
     * @return ios细节
     */
    private Map<String, Object> getIosNotify() {
        Map<String, Object> iosNotify = new HashMap<>(0);
        return iosNotify;
    }


    /**
     * 推送回调配置
     *
     * @param url    回调地址
     * @param params 回调参数
     * @return 回调配置
     */
    private Map<String, Object> getPushCallback(String url, Object params) {
        Map<String, Object> pushCallback = new HashMap<>(2);
        pushCallback.put("url", url);
        pushCallback.put("params", params);
        return pushCallback;
    }

    /**
     * 自定义参数配置
     *
     * @param title   自定义标题
     * @param content 自定义内容
     * @return 自定义参数配置
     */
    private Map<String, Object> getCustomNotify(String title, String content) {
        Map<String, Object> customNotify = new HashMap<>(2);
        customNotify.put("customTitle", title);
        customNotify.put("customType", content);
        return customNotify;
    }

    /**
     * mob 通用post请求
     *
     * @param map 请求参数
     * @param url 请求地址
     * @return 执行结果
     */
    private String generalPost(Map<String, Object> map, String url) {
        String request;
        if (map == null) {
            request = "";
        } else {
            request = JSONObject.toJSONString(map);
        }
        log.error("mob推送内容:{}", request);
        HttpRequest post = HttpUtil.createPost(url);
        post.header("Content-Type", "application/json");
        post.header("key", APP_KEY);
        post.header("sign", getSign(request));
        String body = post.body(request).execute().body();
        log.error("mob推送结果:{}", body);
        if (JSONUtil.isJson(body)) {
            JSONObject json = JSONObject.parseObject(body);
            if (json.containsKey("status") && json.getInteger("status").equals(200))
                return body;
        }
        return null;
    }

    /**
     * mob 通用get请求
     *
     * @param url 请求路径
     * @return 执行结果
     */
    private String generalGet(String url) {
        HttpRequest get = HttpUtil.createGet(url);
        get.header("key", APP_KEY);
        get.header("sign", getSign(""));
        String body = get.execute().body();
        log.info("推送结果:{}", body);
        if (JSONUtil.isJson(body)) {
            JSONObject json = JSONObject.parseObject(body);
            if (json.containsKey("status") && json.getInteger("status").equals(200))
                return body;
        }
        return null;
    }

    /**
     * 获取签名 请求体+AppSecret来进行MD5加密
     *
     * @param body 请求体
     * @return sign
     */
    private String getSign(String body) {
        return SecureUtil.md5(body + APP_SECRET);
    }
}
