package com.weface.serviceimpl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.dao.UserTagDao;
import com.weface.dto.MenuTagsForm;
import com.weface.entity.UserTagEntity;
import com.weface.service.UserTagService;
import com.weface.common.utils.PageUtils;
import com.weface.common.utils.Query;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * @author Administrator
 */
@Service("tUserTagService")
public class UserTagServiceImpl extends ServiceImpl<UserTagDao, UserTagEntity> implements UserTagService {

    @Override
    public List<UserTagEntity> findUserByTodayAndIdBefore(Integer id) {
        return this.baseMapper.findUserByTodayAndIdBefore(id);
    }

    @Override
    public List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit) {
        return this.baseMapper.findUserByIdAfter(id, limit);
    }

    @Override
    public List<UserTagEntity> findNoTagUser(Integer star, Integer end) {
        return this.baseMapper.findNoTagUser(star, end);
    }

    @Override
    public PageUtils getUserAndTags(Map<String, Object> params) {
        IPage<Object> page = new Query<>().getPage(params);
        String gid = (String) params.get("gid");
        IPage<UserTagEntity> userAndTagsByUid = this.baseMapper.getUserAndTags(new Page<UserTagEntity>(page.getCurrent(), page.getSize()), gid);
        userAndTagsByUid.setTotal(userAndTagsByUid.getRecords().size());
        return new PageUtils(userAndTagsByUid);
    }

    @Override
    public List<String> getGidByTag(String[] tags) {
        return this.baseMapper.getGidByTag(Arrays.asList(tags));
    }

    @Override
    public Map<String, Object> getTagByGid(String gid) {
        List<UserTagEntity> userByUid = this.baseMapper.getTagByGid(gid);
        List<Map<String, Object>> list = new ArrayList<>(userByUid.size());
        for (UserTagEntity tUserTagEntity : userByUid) {
            Map<String, Object> map = new HashMap<>(2);
            List<MenuTagsForm> objects = new ArrayList<>();
            tUserTagEntity.getList().forEach(item -> {
                MenuTagsForm menuTagsForm = new MenuTagsForm();
                BeanUtils.copyProperties(item, menuTagsForm);
                objects.add(menuTagsForm);
            });
            map.put("userId", tUserTagEntity.getGid());
            map.put("tags", objects);
            list.add(map);
        }
        Map<String, Object> map = new HashMap<>(2);
        map.put("error_code", 0);
        map.put("userTag", list);
        return map;
    }

    @Override
    public List<UserTagEntity> getAllImport() {
        return this.baseMapper.selectAllUserForTags();
    }


}