package com.weface;


import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.weface.common.utils.RedisUtil;
import com.weface.component.GeTuiService;
import com.weface.component.MenuService;
import com.weface.component.MessageTemplate;
import com.weface.config.GeTuiApp;
import com.weface.dto.InformForm;
import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserMenusEntity;
import com.weface.entity.UserTagEntity;
import com.weface.service.MenuTagsService;
import com.weface.service.UserMenusService;
import com.weface.service.UserTagService;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import javax.annotation.Resource;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@SpringBootTest
class PushMessageApplicationTests {
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private UserMenusService userMenusService;
    @Autowired
    private MenuTagsService menuTagsService;

    @Autowired
    private GeTuiService geTuiService;

    @Resource
    private GeTuiApp geTuiApp;

    @Test
    void contextLoads() {
    }

    /**
     * 根据时间同步标签
     */
    @Test
    public void testKKSB() {
        try {
            //77164
            //已处理0
            //每次处理总条数 20000
            int star = 10000;
            int end = 30000;
            List<MenuTagsEntity> tags = menuTagsService.list();
            List<UserTagEntity> todayUser = userTagService.findNoTagUser(star, end);
            List<String> todayGid = todayUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
            int size = todayGid.size();
            int limit = 1000;
            List<UserMenusEntity> userMenusList = new ArrayList<>();
            int totalPage = (size % limit == 0) ? (size / limit) : (size / limit + 1);
            CountDownLatch latch = new CountDownLatch(totalPage);
            ExecutorService pool = Executors.newFixedThreadPool(totalPage);
            //收集中间表数据
            for (int i = 0; i < totalPage; i++) {
                int finalI = i;
                Runnable runnable = () -> {
                    List<String> list;
                    if (finalI == totalPage - 1) {
                        list = todayGid.subList(finalI * limit, size);
                    } else {
                        list = todayGid.subList(finalI * limit, (finalI + 1) * limit);
                    }
                    if (CollectionUtils.isNotEmpty(list)) {
                        Map<String, Object> android = menuService.getUserTags(list, tags);
                        List<UserMenusEntity> tagUser = menuService.getTagUser(android, todayUser);
                        if (CollectionUtils.isNotEmpty(tagUser)) {
                            userMenusList.addAll(tagUser);
                        }
                    }
                    latch.countDown();
                };
                pool.execute(runnable);
            }
            latch.await();
            userMenusService.batchInsert(userMenusList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testConventTemplate() throws UnsupportedEncodingException {
        InformForm informForm = new InformForm();

//        String[] alias = {"kksh_10131492"};
        String[] alias = {"kksh_59354"};

        String token = geTuiService.getAuthToken("kk_sh_token_ge_tui");
//        String token = geTuiService.getAuthToken("kk_sb_token_ge_tui");

        informForm.setTitle("河南一名小学生确诊阳性！");
        informForm.setBody("1月23日新增一例本土确诊病例！为11岁小学生");
        informForm.setUrl("https://kk.weface.com.cn/news/page/?id=c0933d0e2fc85f7333b6202dff0e611c&type=hot&from=101");

        MessageTemplate messageTemplate = new MessageTemplate();
        messageTemplate.setAudience(new MessageTemplate.Audience(alias));

        messageTemplate.setSettings(new MessageTemplate.Settings(3600000, 0));

        MessageTemplate.PushMessage pushMessage = new MessageTemplate.PushMessage();

        MessageTemplate.PushMessage.Transmission transmission = new MessageTemplate.PushMessage.Transmission();
        transmission.setTitle(informForm.getTitle());
        transmission.setContent(informForm.getBody());
        transmission.setUrl(informForm.getUrl());

        pushMessage.setTransmission(transmission);

        messageTemplate.setPush_message(pushMessage);
        String s = geTuiService.singlePushAlias(4, messageTemplate, geTuiService.getAppId("kksh"), token);
//        String s = geTuiService.singlePushAlias(1, messageTemplate, geTuiService.getAppId("kksb"), token);
        System.out.println(s);
    }


    @Test
    void testRevoke() {
        Map<String, Object> map = new HashMap<>();
        map.put("request_id", String.valueOf(IdUtil.getSnowflake(1, 1).nextId()));
        map.put("audience", "all");

        Map<String, Object> push_message = new HashMap<>();
        HashMap<String, Object> revoke = new HashMap<>();
        revoke.put("old_task_id", "RASA_0127_011f801354c5236738787cdda86cf232");
        revoke.put("force", false);
        push_message.put("revoke", revoke);
        map.put("push_message", push_message);
        String url = GeTuiService.GE_TUI_BASE_URL + geTuiService.getAppId("kksh") + "/push/all";
        String kk_sh_token_ge_tui = geTuiService.getAuthToken("kk_sh_token_ge_tui");
        String s = geTuiService.generalPost(url, kk_sh_token_ge_tui, map);
        System.out.println(s);
    }

    @Test
    void testPush() {
        //获取标签列表
        List<MenuTagsEntity> tags = menuTagsService.list();
        List<String> list = Collections.singletonList("d7e78cfa76e1c61699925ec9bb960d53");
        Map<String, Object> userTags = menuService.getUserTags(list, tags);
        System.out.println(userTags);
    }

    @Test
    void testExportExcel() throws IOException {
        //大数据写入excel
        SXSSFWorkbook sxssfWorkbook = null;
        //读取excel
        XSSFWorkbook workbook;
        //输出流
        FileOutputStream fos = null;
        //读取流
        FileInputStream fis = null;
        try {
            //写入
            sxssfWorkbook = new SXSSFWorkbook();
            sxssfWorkbook.setCompressTempFiles(true);// 打开压缩功能 防止占用过多磁盘
            Sheet sheet = sxssfWorkbook.createSheet("存钱罐用户标签统计");

            //读取
            fis = new FileInputStream("C:\\Users\\Administrator\\Desktop\\用户画像编码表(1).xlsx");
            workbook = new XSSFWorkbook(fis);
            XSSFSheet sheetAt = workbook.getSheetAt(5);
            int limit = 10000;
            int rowNum = sheetAt.getPhysicalNumberOfRows();
            int size = rowNum % limit == 0 ? (rowNum / limit) : (rowNum / limit + 1);
            for (int i = 0; i < size; i++) {
                List<String> list;
                if (i == size - 1) {
                    list = getCellValue(sheetAt, i * limit + 1, rowNum % limit);
                } else {
                    list = getCellValue(sheetAt, i * limit + 1, limit);
                }
                List<UserTagEntity> userTags = userTagService.findUserTags(list);
                int x = 1;
                for (UserTagEntity userTag : userTags) {
                    String uid = userTag.getUid();
                    List<MenuTagsEntity> tags = userTag.getList();
                    Row row = sheet.createRow(x);
                    x++;
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue(uid);
                    int j = 1;
                    for (MenuTagsEntity menuTagsEntity : tags) {
                        Cell cell = row.createCell(j);
                        j++;
                        cell.setCellValue(menuTagsEntity.getLevelThird());
                    }
                }
            }
            fos = new FileOutputStream("C:/Users/Administrator/Desktop/tags.xlsx");
            sxssfWorkbook.write(fos);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (sxssfWorkbook != null) {
                sxssfWorkbook.dispose();
            }
        }
    }

    /**
     * @param sheetAt 表格
     * @param star    处理起始行
     * @param limit   当前需处理多少行
     * @return 数据
     */
    private List<String> getCellValue(XSSFSheet sheetAt, int star, int limit) {
        List<String> list = new ArrayList<>();
        for (int i = 0; i < limit; i++) {
            XSSFRow row = sheetAt.getRow(star);
            if (row == null) {
                continue;
            }
            XSSFCell cell = row.getCell(0);
            star++;
            String value = cell.getStringCellValue();
            list.add(value);
        }
        return list;
    }

    @Test
    void getAllTags() {
        List<MenuTagsEntity> list = menuTagsService.list();
        Set<String> level_first = list.stream().map(MenuTagsEntity::getLevelFirst).collect(Collectors.toSet());
        Map<String, Object> first_map = new HashMap<>();
        for (String first : level_first) {
            Set<String> level_second = list.stream().filter(x -> first.equals(x.getLevelFirst())).map(MenuTagsEntity::getLevelSecond).collect(Collectors.toSet());
            Map<String, Object> second_map = new HashMap<>();
            for (String second : level_second) {
                List<MenuTagsEntity> level_third = list.stream().filter(x -> second.equals(x.getLevelSecond()) && first.equals(x.getLevelFirst())).collect(Collectors.toList());
                second_map.put(second, level_third);
            }
            first_map.put(first, second_map);
        }
        System.out.println(first_map);
    }

    @Test
    void testRandom() {
        String token = "54_qYwZpVbWrJDkflE1ha61B4SPwdhNVoCE6g_YG9zL0PL2ki6pZYsNKK__l2fMfmjRyt3C_EIiTq2Hnnla5MK8bGLckSUXUN14_A2UKMhF9xsVHQswPd6MnmVxV1YkSAyFVLEpF76kuCbBmps7GZOfAFAWPE";

//        String token = "54_hksRqu53_0Jmw_lopjrJh4Ofzqzb_289qRkfZXxIVhBhk4vjSFH-20sbf6LUg8X1Go4tkVoISnFTSWiyKKUB1Pw8-KKNM8W6GsSpGsj85_fTtm5Uus7ncmkQCS_LxTAybYsUfsU6VaBm6hnHKJSeAAAUTC";
        RedisUtil.StringOps.setEx("kksh_wechat:mini_program_token:10011", token, 5400, TimeUnit.SECONDS);

//        String appId = "wx0c0e88fde84cc81c";
//        String secret = "45aae2597122419a74297d5987965013";


//        String code = "ce863cb4acfa518fc6893686d3e9480a0fd5b4b4ba99dd3d68d5ac4e50775943";
//        String userPhone = getUserPhone("10011", code);
//        System.out.println(userPhone);
    }

    private static Map<String, String> getAppId(String programType) {
        String appId;
        String secret;
        if ("10011".equals(programType)) {
            appId = "wx93e88ce737b22930";
            secret = "968ece96a90fb21095005c9d26893f4a";
        } else {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        map.put("appId", appId);
        map.put("secret", secret);
        return map;
    }

    public static String getUserPhone(String programType, String code) {
        String token = getWeChatToken(programType);
        //参数错误 获取token失败
        if (token == null || token.equals("")) {
            return "17";
        }
        String phone = null;
        boolean flag = false;
        while (!flag) {
            String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=%s";
            String format = String.format(url, token);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", code);
            String body = HttpRequest.post(format).body(jsonObject.toString()).execute().body();
            if (JSONUtil.isJson(body)) {
                JSONObject json = JSONUtil.parseObj(body);
                if (json.containsKey("errcode")) {
                    Integer errCode = json.getInt("errcode");
                    if (errCode == 0) {
                        phone = json.getJSONObject("phone_info").getStr("phoneNumber");
                        flag = true;
                    } else if (errCode == 42001 || errCode == 40014 || errCode == 41001) {
                        token = getWeChatToken(getAppId(programType));
                        RedisUtil.StringOps.setEx("kksh_wechat:mini_program_token:" + programType, token, 5400, TimeUnit.SECONDS);
                        flag = false;
                    } else {
                        phone = String.valueOf(json.getInt("errcode"));
                        flag = true;
                    }
                } else {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        return phone;
    }


    /**
     * 获取微信小程序token
     *
     * @return token
     */
    private static String getWeChatToken(String programType) {
        String token = RedisUtil.StringOps.get("kksh_wechat:mini_program_token:" + programType);
        if (StringUtils.isBlank(token)) {
            Map<String, String> map = getAppId(programType);
            token = getWeChatToken(map);
            if (StringUtils.isBlank(token)) {
                RedisUtil.StringOps.setEx("kksh_wechat:mini_program_token:" + programType, token, 5400, TimeUnit.SECONDS);
            }
        }
        return token;
    }


    /**
     * 获取小程序token
     *
     * @param map 应用信息
     * @return token
     */
    private static String getWeChatToken(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=%s&appid=%s&secret=%s";
        String grant_type = "client_credential";
        String auth_url = String.format(url, grant_type, map.get("appId"), map.get("secret"));
        String body = HttpRequest.get(auth_url).execute().body();
        if (JSONUtil.isJson(body)) {
            JSONObject json = JSONUtil.parseObj(body);
            if (json.containsKey("access_token")) {
                return json.getStr("access_token");
            } else {
                System.out.println(body);
            }
        } else {
            System.out.println(body);
        }
        return null;
    }
}
