package com.weface.serviceimpl;

import com.weface.code.CommonResult;
import com.weface.dto.MsgDTO;
import com.weface.dto.PushDTO;
import com.weface.service.AsyncService;
import com.weface.service.PushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushServiceImpl implements PushService {

    @Autowired
    private AsyncService asyncService;

    @Override
    public CommonResult pushList(PushDTO param) throws Exception {
        asyncService.batchPush(param.getUserList(),param.getFromApp());
        return CommonResult.success(null);
    }

    @Override
    public CommonResult pushSingle(MsgDTO param) {
        asyncService.pushSingle(param);
        return CommonResult.success(null);
    }
}
