package com.weface.controller;

import com.weface.code.CommonResult;
import com.weface.component.GeTuiService;
import com.weface.dto.InformForm;
import com.weface.dto.MsgDTO;
import com.weface.dto.PushDTO;
import com.weface.service.PushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.groups.Default;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("push")
public class PushController {

    @Autowired
    private PushService pushService;
    @Autowired
    private GeTuiService geTuiService;


    @PostMapping("list")
    public CommonResult pushList(@RequestBody PushDTO param) throws Exception {
        return pushService.pushList(param);
    }

    @PostMapping("single")
    public CommonResult pushSingle(@RequestBody MsgDTO param) {
        return pushService.pushSingle(param);
    }

    @PostMapping("/all")
    public CommonResult pushAll(@Validated({Default.class}) InformForm informForm) {
        return geTuiService.listPush(informForm);
    }
}
