package com.weface.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.dto.InformForm;
import com.weface.entity.PushLogEntity;

import java.util.List;

/**
 * @author admin
 * @date 2022-04-20 09:54:09
 */
public interface PushLogService extends IService<PushLogEntity> {

    /**
     * 保存日志
     *
     * @param data       返回数据
     * @param informForm 推送数据
     * @param appId      应用id
     */
    public void saveLog(JSONObject data, InformForm informForm, String appId);

    /**
     * 查询日志
     *
     * @param taskId 任务id
     * @return 日志信息
     */
    public PushLogEntity getPushLog(String taskId);

    /**
     * 查询推送日志
     *
     * @param time 时间
     * @return 推送日志
     */
    public List<PushLogEntity> getPushLogByTime(Integer time);
}

