package com.weface.component;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author Administrator
 * @CreateTime: 2021/11/23
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessageTemplate implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 任务组
     */
    private String group_name;
    /**
     * 推送目标用户该接口audience 对应值为all，表示推送所有用户
     */
    private Audience audience;
    /**
     * 推送条件设置
     */
    private Settings settings;
    /**
     * 个推推送消息参数
     */
    private PushMessage push_message;
    /**
     * 推送目标用户该接口audience 对应值为all，表示推送所有用户
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Audience implements Serializable {
        private static final long serialVersionUID = 1L;
        //别名数组，只能填一个别名
        private String[] alias;
    }

    /**
     * 推送条件设置
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Settings implements Serializable {
        private static final long serialVersionUID = 1L;
        //消息离线时间设置，单位毫秒，-1表示不设离线，-1 ～ 3 * 24 * 3600 * 1000(3天)之间
        private Integer ttl;
        //定速推送，例如100，个推控制下发速度在100条/秒左右，0表示不限速
        private Integer speed;
    }

    /**
     * 个推推送消息参数
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PushMessage implements Serializable {
        private static final long serialVersionUID = 1L;
        //手机端通知展示时间段，格式为毫秒时间戳段，两个时间的时间差必须大于10分钟，例如："1590547347000-1590633747000"
        private String duration;
        //纯透传消息内容，安卓和iOS均支持，与notification、revoke 三选一，都填写时报错，长度 ≤ 3072
        private Transmission transmission;
        //消息模板
        private Notification notification;
        //撤回消息时使用(仅撤回个推通道消息)，与notification、transmission三选一，都填写时报错(消息撤回请勿填写策略参数)
        private Revoke revoke;

        @Data
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Notification implements Serializable {
            private static final long serialVersionUID = 1L;
            private String title;
            private String body;
            private String big_text;
            private String big_image;
            private String logo;
            private String logo_url;
            private String channel_id;
            private String channel_name;
            private Integer channel_level;
            private String click_type;
            private String intent;
            private String url;
            private String payload;
            private Integer notify_id;
            private String ring_name;
            private Integer badge_add_num;
            private String thread_id;
        }

        @Data
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Transmission {
            private String title;
            private String content;
            private String url;
            //0:h5 1:app原生
            private Integer pushType;
            //跳转功能名称
            private String className;
            //功能标题
            private String classTitle;
            //是否需要登录
            private String needLogin;
        }

        @Data
        public static class Revoke {
            private String old_task_id;
            private Integer force;
        }
    }
}
