package com.weface.serviceimpl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.code.CommonResult;
import com.weface.common.utils.SnowIdUtil;
import com.weface.dao.UserMenusDao;
import com.weface.dto.UserMenuFrom;
import com.weface.entity.UserMenusEntity;
import com.weface.service.UserMenusService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service("userMenusService")
@Transactional(rollbackFor = {Exception.class})
public class UserMenusServiceImpl extends ServiceImpl<UserMenusDao, UserMenusEntity> implements UserMenusService {

    /**
     * 批量插入
     *
     * @param userMenusList 被插入数据
     */
    @Override
    public void batchInsert(List<UserMenusEntity> userMenusList) {
        if (CollUtil.isNotEmpty(userMenusList)) {
            List<String> deleteUid = getDeleteUid(userMenusList);
            //批量插入前全删
            List<Long> ids = this.baseMapper.findIdByUserId(deleteUid);
            this.removeByIds(ids);
            //获取集合长度
            int count = userMenusList.size();
            //每次批量插入个数
            int limit = 10000;
            int sum = 0;
            //计算页数
            int totalPage = (count % limit == 0) ? (count / limit) : (count / limit + 1);
            for (int i = 0; i < totalPage; i++) {
                List<UserMenusEntity> userMenusEntities = new ArrayList<>(10000);
                //如果是最后一页,则截取到最后
                if (i == totalPage - 1) {
                    userMenusEntities = userMenusList.subList(i * limit, count);
                } else {
                    userMenusEntities = userMenusList.subList(i * limit, (i + 1) * limit);
                }
                //批量插入每次一万条
                sum += this.baseMapper.batchInsert(userMenusEntities);
            }
            if (sum > 0) {
                log.warn("新增成功记录=={}==条", sum);
            } else {
                log.error("新增失败");
            }
        }
    }

    @Override
    public CommonResult saveUserTag(UserMenuFrom userMenuFrom) {
        try {
            String userId = userMenuFrom.getUserId();
            String[] tagsId = userMenuFrom.getTagsId();
            List<UserMenusEntity> list = this.list(new QueryWrapper<UserMenusEntity>().eq("user_id", userId).in("tags_id", Arrays.asList(tagsId)));
            List<String> saveTags = Arrays.asList(tagsId);
            if (CollUtil.isNotEmpty(list)) {
                List<String> collect = list.stream().map(x -> String.valueOf(x.getTagsId())).collect(Collectors.toList());
                saveTags = saveTags.stream().filter(item -> !collect.contains(item)).collect(Collectors.toList());
//                removeByIds(collect);
            }
            if (CollUtil.isEmpty(saveTags)) {
                return CommonResult.failed("用户标签已存在");
            }
            List<UserMenusEntity> userMenusEntities = new ArrayList<>(tagsId.length);
            for (String aLong : saveTags) {
                UserMenusEntity userMenusEntity = new UserMenusEntity();
                userMenusEntity.setId(SnowIdUtil.nextId());
                userMenusEntity.setUserId(userId);
                userMenusEntity.setTagsId(Convert.toLong(aLong));
                userMenusEntity.setCreateTime(new Date());
                userMenusEntity.setIsValid(1);
                userMenusEntities.add(userMenusEntity);
            }
            int i = this.baseMapper.batchInsert(userMenusEntities);
            if (i > 0) {
                return CommonResult.success();
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("保存用户标签信息失败{}", e.getMessage());
        }
        return CommonResult.failed();
    }

    @Override
    public CommonResult delUserTag(UserMenuFrom userMenuFrom) {
        try {
            String userId = userMenuFrom.getUserId();
            String[] tagsId = userMenuFrom.getTagsId();
            this.remove(new LambdaQueryWrapper<UserMenusEntity>().eq(UserMenusEntity::getUserId, userId).in(UserMenusEntity::getTagsId, Arrays.asList(tagsId)));
            return CommonResult.success();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("删除用户标签失败!{}", e.getMessage());
        }
        return CommonResult.failed();
    }

    /**
     * 查询删除的uid
     *
     * @param userMenusList 用户标签信息
     * @return 提取用户uid
     */
    private List<String> getDeleteUid(List<UserMenusEntity> userMenusList) {
        return userMenusList.stream().map(UserMenusEntity::getUserId).distinct().collect(Collectors.toList());
    }

}