package com.weface.code;

public enum ResultCode implements IErrorCode {
    SUCCESS(200, "操作成功"),
    FAILED(500, "操作失败"),
    VALIDATE_FAILED(404, "参数检验失败"),
    UNAUTHORIZED(401, "暂未登录或token已经过期"),
    PARAMS_ERROR(40001, "参数错误不能为空"),
    CONTENT_MORE_LENGTH(40002, "推送内容过长超过60字符"),
    NOT_SIGN_ERROR(50003, "签名信息不可为空"),
    REQUEST_EXPIRE_ERROR(50004, "请求已过期"),
    CANNOT_ANALYSIS_PARAM_ERROR(50005, "无法解析的请求参数"),
    SIGN_VALID_FAIL_ERROR(50006, "签名校验失败"),
    FORBIDDEN(403, "没有相关权限");
    private final Integer code;
    private final String message;

    private ResultCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
