package com.weface.enums;

import java.math.BigDecimal;

/**
 * 新闻消息推送APP_KEY ENUMS
 *
 * @author mht
 * @date 2024/12/17
 */
public enum AppKeyEnum {

    /**
     * 安卓
     */
    ANDROID("3511c2579cad6", "f446a56b98aae09beb5721ebdbe0d2e8"),
    /**
     * IOS
     */
    IOS("38b797dbbf6ec", "05883c7b9185edb99a6ded653cfe3e39"),
    /**
     * 鸿蒙
     */
    HARMONY("3a69c3c5f3cc7", "78f9a9f474086eee124b2be762e356ca"),

    ;

    private String key;

    private String secret;

    AppKeyEnum(String key, String secret) {
        this.key = key;
        this.secret = secret;
    }

    public String getKey() {
        return key;
    }


    public String getSecret() {
        return secret;
    }

    /**
     * 根据freezeAmt获取medicareAmt
     *
     * @param key appKey
     * @return {@link String }
     */
    public static String getSecretByKey(String key) {
        AppKeyEnum[] enums = AppKeyEnum.values();
        for (int i = 0; i < enums.length; i++) {
            if (enums[i].getKey().equals(key)) {
                return enums[i].getSecret();
            }
        }
        return null;
    }
}

