package com.weface.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.weface.entity.UserMenusEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 用户和标签中间表
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
@Mapper
public interface UserMenusDao extends BaseMapper<UserMenusEntity> {

    /**
     * 批量插入
     *
     * @param list 插入数据
     * @return 成功条数
     */
    int batchInsert(List<UserMenusEntity> list);

    /**
     * 根据uid查询标签id
     *
     * @param list gid
     * @return 标签id
     */
    List<Long> findIdByUserId(List<String> list);

}
