package com.weface.controller;

import com.alibaba.fastjson.JSONObject;
import com.weface.code.CommonResult;
import com.weface.common.utils.Constant;
import com.weface.common.validator.ValidatorParam;
import com.weface.common.validator.ValidatorUtils;
import com.weface.component.GeTuiService;
import com.weface.component.MobPushService;
import com.weface.dto.InformForm;
import com.weface.dto.MsgDTO;
import com.weface.dto.MultiInformForm;
import com.weface.dto.PushDTO;
import com.weface.service.PushService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("push")
public class PushController {

    @Autowired
    private PushService pushService;
    @Autowired
    private GeTuiService geTuiService;
    @Autowired
    private MobPushService mobPushService;

    @PostMapping("list")
    public CommonResult pushList(@RequestBody PushDTO param) throws Exception {
        return pushService.pushList(param);
    }

    @PostMapping("single")
    public CommonResult pushSingle(@RequestBody MsgDTO param) {
        return pushService.pushSingle(param);
    }

    /**
     * 群推
     */
    @PostMapping("/all")
    public CommonResult pushAll(InformForm informForm) {
        log.error("群推内容:{}", JSONObject.toJSONString(informForm));
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult result = ValidatorParam.validPushParams(informForm);
        if (result != null) {
            return result;
        }
        if (informForm.getEquipmentType().equals("kksh")) {
            //安卓群推
            mobPushService.mobPushForAndroid(informForm, Constant.PushTarget.RADIO);
            //IOS群推
            mobPushService.mobPushForIOS(informForm, Constant.PushTarget.RADIO);
            //鸿蒙群推
            mobPushService.mobPushForHarmony(informForm, Constant.PushTarget.RADIO);
        }
        return geTuiService.listPush(informForm);
    }

    /**
     * 别名单推
     */
    @PostMapping("/single/alias")
    public CommonResult pushSingleAlias(@RequestBody InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult result = ValidatorParam.validPushParams(informForm);
        if (result != null) {
            return result;
        }
        result = ValidatorParam.validPushSingleAlias(informForm);
        if (result != null) {
            return result;
        }
        result = mobPushService.mobPush(informForm, Constant.PushTarget.ALIAS);
        if (result != null) {
            return CommonResult.success();
        }
        return geTuiService.pushSingleAlias(informForm);
    }

    /**
     * cid单推
     */
    @PostMapping("/single/cid")
    public CommonResult pushSingleCid(@RequestBody InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult result = ValidatorParam.validPushParams(informForm);
        if (result != null) {
            return result;
        }
        result = ValidatorParam.validPushSingleAlias(informForm);
        if (result != null) {
            return result;
        }
        result = mobPushService.mobPush(informForm, Constant.PushTarget.RIDS);
        if (result != null) {
            return CommonResult.success();
        }
        return geTuiService.pushSingleCid(informForm);
    }

    /**
     * 别名批量推送
     */
    @PostMapping("/list/alias")
    public CommonResult pushListMessage(@RequestBody InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        String result = geTuiService.pushListMessage(informForm, true);
        if (StringUtils.isEmpty(result)) {
            return CommonResult.failed("推送失败");
        } else {
            return CommonResult.success(result, "推送成功");
        }
    }


    /**
     * 别名批量推送
     */
    @PostMapping("/batch/alias")
    public CommonResult batchMobPush(@RequestBody @Validated MultiInformForm multiInformForm) {
        CommonResult result = ValidatorParam.validBatchPushParams(multiInformForm);
        if (result != null) {
            return result;
        }
        return mobPushService.batchMobPush(multiInformForm);

    }

    /**
     * 别名批量推送
     */
    @PostMapping("/region")
    public CommonResult region(@RequestBody @Validated InformForm informForm) {
        ValidatorUtils.validateEntity(informForm, InformForm.PushValid.class);
        CommonResult result = ValidatorParam.validPushParams(informForm);
        if (result != null) {
            return result;
        }
        result = ValidatorParam.validRegion(informForm);
        if (result != null) {
            return result;
        }
        return mobPushService.mobPush(informForm, Constant.PushTarget.CITY);

    }
}
