package com.weface;


import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.weface.code.CommonResult;
import com.weface.common.utils.CommonUtil;
import com.weface.common.utils.RedisUtil;
import com.weface.common.utils.SnowIdUtil;
import com.weface.component.GeTuiService;
import com.weface.component.MenuService;
import com.weface.config.SignValidateFilter;
import com.weface.dto.InformForm;
import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserMenusEntity;
import com.weface.entity.UserTagEntity;
import com.weface.service.MenuTagsService;
import com.weface.service.UserMenusService;
import com.weface.service.UserTagService;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@SpringBootTest
class PushMessageApplicationTests {
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private UserMenusService userMenusService;
    @Autowired
    private MenuTagsService menuTagsService;

    @Autowired
    private GeTuiService geTuiService;

    @Test
    void contextLoads() {
    }

    /**
     * 根据时间同步标签
     */
    @Test
    public void testKKSB() {
        try {
            //77164
            //已处理0
            //每次处理总条数 20000
            int star = 10000;
            int end = 30000;
            List<MenuTagsEntity> tags = menuTagsService.list();
            List<UserTagEntity> todayUser = userTagService.findNoTagUser(star, end);
            List<String> todayGid = todayUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
            int size = todayGid.size();
            int limit = 1000;
            List<UserMenusEntity> userMenusList = new ArrayList<>();
            int totalPage = (size % limit == 0) ? (size / limit) : (size / limit + 1);
            CountDownLatch latch = new CountDownLatch(totalPage);
            ExecutorService pool = Executors.newFixedThreadPool(totalPage);
            //收集中间表数据
            for (int i = 0; i < totalPage; i++) {
                int finalI = i;
                Runnable runnable = () -> {
                    List<String> list;
                    if (finalI == totalPage - 1) {
                        list = todayGid.subList(finalI * limit, size);
                    } else {
                        list = todayGid.subList(finalI * limit, (finalI + 1) * limit);
                    }
                    if (CollectionUtils.isNotEmpty(list)) {
                        Map<String, Object> android = menuService.getUserTags(list, tags);
                        List<UserMenusEntity> tagUser = menuService.getTagUser(android, todayUser);
                        if (CollectionUtils.isNotEmpty(tagUser)) {
                            userMenusList.addAll(tagUser);
                        }
                    }
                    latch.countDown();
                };
                pool.execute(runnable);
            }
            latch.await();
            userMenusService.batchInsert(userMenusList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Test
    void testRevoke() {
        String taskId = "RASA_0726_e51c93e787d103e072e4cd2cd43e8500";
        String equipmentType = "kksh";
        String s = geTuiService.revokeTask(taskId, equipmentType);
        System.out.println(s);
    }

    @Test
    void testPushResult(){
        String taskId = "RASA_0726_e51c93e787d103e072e4cd2cd43e8500";
        String equipmentType = "kksh";
        String s = geTuiService.getReportByTaskId(taskId, equipmentType);
        System.out.println(s);
    }

    @Test
    void testUserTags() {
        //获取标签列表
        List<MenuTagsEntity> tags = menuTagsService.list();
        List<String> list = Collections.singletonList("d7e78cfa76e1c61699925ec9bb960d53");
        Map<String, Object> userTags = menuService.getUserTags(list, tags);
        System.out.println(userTags);
    }

    @Test
    void testExportExcel() throws IOException {
        //大数据写入excel
        SXSSFWorkbook sxssfWorkbook = null;
        //读取excel
        XSSFWorkbook workbook;
        //输出流
        FileOutputStream fos = null;
        //读取流
        FileInputStream fis = null;
        try {
            //写入
            sxssfWorkbook = new SXSSFWorkbook();
            sxssfWorkbook.setCompressTempFiles(true);// 打开压缩功能 防止占用过多磁盘
            Sheet sheet = sxssfWorkbook.createSheet("存钱罐用户标签统计");

            //读取
            fis = new FileInputStream("C:\\Users\\Administrator\\Desktop\\用户画像编码表(1).xlsx");
            workbook = new XSSFWorkbook(fis);
            XSSFSheet sheetAt = workbook.getSheetAt(5);
            int limit = 10000;
            int rowNum = sheetAt.getPhysicalNumberOfRows();
            int size = rowNum % limit == 0 ? (rowNum / limit) : (rowNum / limit + 1);
            for (int i = 0; i < size; i++) {
                List<String> list;
                if (i == size - 1) {
                    list = getCellValue(sheetAt, i * limit + 1, rowNum % limit);
                } else {
                    list = getCellValue(sheetAt, i * limit + 1, limit);
                }
                List<UserTagEntity> userTags = userTagService.findUserTags(list);
                int x = 1;
                for (UserTagEntity userTag : userTags) {
                    String uid = userTag.getUid();
                    List<MenuTagsEntity> tags = userTag.getList();
                    Row row = sheet.createRow(x);
                    x++;
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue(uid);
                    int j = 1;
                    for (MenuTagsEntity menuTagsEntity : tags) {
                        Cell cell = row.createCell(j);
                        j++;
                        cell.setCellValue(menuTagsEntity.getLevelThird());
                    }
                }
            }
            fos = new FileOutputStream("C:/Users/Administrator/Desktop/tags.xlsx");
            sxssfWorkbook.write(fos);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (sxssfWorkbook != null) {
                sxssfWorkbook.dispose();
            }
        }
    }

    /**
     * @param sheetAt 表格
     * @param star    处理起始行
     * @param limit   当前需处理多少行
     * @return 数据
     */
    private List<String> getCellValue(XSSFSheet sheetAt, int star, int limit) {
        List<String> list = new ArrayList<>();
        for (int i = 0; i < limit; i++) {
            XSSFRow row = sheetAt.getRow(star);
            if (row == null) {
                continue;
            }
            XSSFCell cell = row.getCell(0);
            star++;
            String value = cell.getStringCellValue();
            list.add(value);
        }
        return list;
    }

    @Test
    void getAllTags() {
        List<MenuTagsEntity> list = menuTagsService.list();
        Set<String> level_first = list.stream().map(MenuTagsEntity::getLevelFirst).collect(Collectors.toSet());
        Map<String, Object> first_map = new HashMap<>();
        for (String first : level_first) {
            Set<String> level_second = list.stream().filter(x -> first.equals(x.getLevelFirst())).map(MenuTagsEntity::getLevelSecond).collect(Collectors.toSet());
            Map<String, Object> second_map = new HashMap<>();
            for (String second : level_second) {
                List<MenuTagsEntity> level_third = list.stream().filter(x -> second.equals(x.getLevelSecond()) && first.equals(x.getLevelFirst())).collect(Collectors.toList());
                second_map.put(second, level_third);
            }
            first_map.put(first, second_map);
        }
        System.out.println(first_map);
    }

    private static Map<String, String> getAppId(String programType) {
        String appId;
        String secret;
        if ("10011".equals(programType)) {
            appId = "wx93e88ce737b22930";
            secret = "968ece96a90fb21095005c9d26893f4a";
        } else {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        map.put("appId", appId);
        map.put("secret", secret);
        return map;
    }

    public static String getUserPhone(String programType, String code) {
        String token = getWeChatToken(programType);
        //参数错误 获取token失败
        if (token == null || token.equals("")) {
            return "17";
        }
        String phone = null;
        boolean flag = false;
        while (!flag) {
            String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=%s";
            String format = String.format(url, token);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", code);
            String body = HttpRequest.post(format).body(jsonObject.toString()).execute().body();
            if (JSONUtil.isJson(body)) {
                JSONObject json = JSONUtil.parseObj(body);
                if (json.containsKey("errcode")) {
                    Integer errCode = json.getInt("errcode");
                    if (errCode == 0) {
                        phone = json.getJSONObject("phone_info").getStr("phoneNumber");
                        flag = true;
                    } else if (errCode == 42001 || errCode == 40014 || errCode == 41001) {
                        token = getWeChatToken(getAppId(programType));
                        RedisUtil.StringOps.setEx("kksh_wechat:mini_program_token:" + programType, token, 5400, TimeUnit.SECONDS);
                        flag = false;
                    } else {
                        phone = String.valueOf(json.getInt("errcode"));
                        flag = true;
                    }
                } else {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        return phone;
    }


    /**
     * 获取微信小程序token
     *
     * @return token
     */
    private static String getWeChatToken(String programType) {
        String token = RedisUtil.StringOps.get("kksh_wechat:mini_program_token:" + programType);
        if (StringUtils.isBlank(token)) {
            Map<String, String> map = getAppId(programType);
            token = getWeChatToken(map);
            if (StringUtils.isBlank(token)) {
                RedisUtil.StringOps.setEx("kksh_wechat:mini_program_token:" + programType, token, 5400, TimeUnit.SECONDS);
            }
        }
        return token;
    }


    /**
     * 获取小程序token
     *
     * @param map 应用信息
     * @return token
     */
    private static String getWeChatToken(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=%s&appid=%s&secret=%s";
        String grant_type = "client_credential";
        String auth_url = String.format(url, grant_type, map.get("appId"), map.get("secret"));
        String body = HttpRequest.get(auth_url).execute().body();
        if (JSONUtil.isJson(body)) {
            JSONObject json = JSONUtil.parseObj(body);
            if (json.containsKey("access_token")) {
                return json.getStr("access_token");
            } else {
                System.out.println(body);
            }
        } else {
            System.out.println(body);
        }
        return null;
    }

    @Test
    public void testSingleAlias() {
        InformForm informForm = new InformForm();
        informForm.setTitle("缴电费充值通知");
        informForm.setBody("尊敬的用户您好，您的户");
        informForm.setUrl("mineEarnGold");
        informForm.setPushType(1);
        informForm.setClassName("mineEarnGold");
        informForm.setClassTitle("我的金币");
        informForm.setNeedLogin("1");
        informForm.setEquipmentType("kksh");
        informForm.setCid("kksh_59354");
        CommonResult commonResult = geTuiService.pushSingleAlias(informForm);
        System.out.println(commonResult);
    }

    @Test
    public void tesPushApp() {
        InformForm informForm = new InformForm();
        informForm.setTitle("缴电费充值通知");
        informForm.setBody("尊敬的用户您好，您的户");
        informForm.setUrl("mineEarnGold");
        informForm.setPushType(1);
        informForm.setClassName("mineEarnGold");
        informForm.setClassTitle("我的金币");
        informForm.setNeedLogin("1");
        informForm.setEquipmentType("kksh");
        CommonResult commonResult = geTuiService.listPush(informForm);
        System.out.println(commonResult);
    }

    @Test
    public void testSign() {
        //    d9c57eada1389691d86ff4d62787d3cc
        Map<String, Object> map = new HashMap<>();
        map.put("title", "花费充值");
        map.put("body", "尊敬的用户您好，您的户");
        map.put("url", "https://docs.getui.com/getui/mobile/vendor/report/");
        map.put("pushType", "0");
        map.put("equipmentType", "kksh");
        map.put("cid", "kksh_59354");
        map.put("messageTemplate", "1");
        map.put("phone", "15538250098");
        long l = System.currentTimeMillis();
        System.out.println(l);
        map.put("timestamp", l);

        String s = CommonUtil.apiParamSign(map, SignValidateFilter.SECRET_KEY);
        System.out.println(s);
    }
}
