package com.weface.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.common.utils.Constant;
import com.weface.common.utils.DES;
import com.weface.common.utils.RedisUtil;
import com.weface.common.utils.SnowIdUtil;
import com.weface.dao.PushLogDao;
import com.weface.dto.InformForm;
import com.weface.entity.PushLogEntity;
import com.weface.service.PushLogService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Slf4j
@Transactional(rollbackFor = {Exception.class})
@Service("pushLogService")
public class PushLogServiceImpl extends ServiceImpl<PushLogDao, PushLogEntity> implements PushLogService {


    @Override
    public void saveLog(JSONObject data, InformForm informForm, String appId) {
        try {
            List<PushLogEntity> logList = new ArrayList<>();
            for (String key : data.keySet()) {
                PushLogEntity pushLogEntity = new PushLogEntity();
                Long id = SnowIdUtil.nextId();
                pushLogEntity.setId(id);
                pushLogEntity.setAppName(informForm.getEquipmentType());
                pushLogEntity.setTaskId(key);
                String str = data.toString();
                if (str.length() > 200) {
                    pushLogEntity.setResult(str.substring(0, 200));
                } else {
                    pushLogEntity.setResult(str);
                }
                String phone = informForm.getPhone();
                if (StringUtils.isNotEmpty(phone)) {
                    DES des = DES.getInstanceDes();
                    pushLogEntity.setPhone(des.encrypt(phone));
                }
                Integer messageTemplate = informForm.getMessageTemplate();
                if (messageTemplate != null) {
                    pushLogEntity.setMessageTemplate(messageTemplate);
                }
                pushLogEntity.setPushTarget(informForm.getCid() == null ? "all" : informForm.getCid());
                pushLogEntity.setPushContent(informForm.getBody());
                pushLogEntity.setArriveStatus(1001);
                pushLogEntity.setUpdateTime(new Date());
                logList.add(pushLogEntity);
                RedisUtil.HashOps.hPutEx(Constant.PUSH_TASK_INFO, key, String.valueOf(id), 2L, TimeUnit.HOURS);
            }
            if (!CollectionUtils.isEmpty(logList)) {
                this.saveBatch(logList);
            }
        } catch (Exception e) {
            log.error("保存推送日志错误:{}", e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * 查询日志
     *
     * @param taskId 任务id
     * @return 日志信息
     */
    @Override
    public PushLogEntity getPushLog(String taskId) {
        List<PushLogEntity> list = this.list(new LambdaQueryWrapper<PushLogEntity>()
                .eq(PushLogEntity::getTaskId, taskId));
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    /**
     * 查询推送日志
     *
     * @param time 时间
     * @return 推送日志
     */
    @Override
    public List<PushLogEntity> getPushLogByTime(Integer time) {
        return this.baseMapper.getPushLogByTime(time);
    }
}