package com.weface.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.entity.UserTagEntity;
import com.weface.common.utils.PageUtils;

import java.util.List;
import java.util.Map;

/**
 * 用户ID标签关联表
 *
 * @author chenshun
 * @date 2021-11-30 18:57:06
 */
public interface UserTagService extends IService<UserTagEntity> {

    /**
     * 查询用户标签导出
     *
     * @param list 用户uid
     * @return 标签信息
     */
    List<UserTagEntity> findUserTags(List<String> list);

    /**
     * 查询当天的数据
     *
     * @return 当天改变的用户
     */
    List<UserTagEntity> findUserByTodayAndIdBefore(Integer id);

    /**
     * 根据时间查询用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit);


    /**
     * 查询库中无标签用户
     *
     * @param star 起始值
     * @param end  每页数据
     * @return 用户信息
     */
    List<UserTagEntity> findNoTagUser(Integer star, Integer end);

    /**
     * 查询所有用户对应标签信息
     *
     * @param params 參數
     * @return 分頁信息
     */
    PageUtils getUserList(Map<String, Object> params);

}

