package com.weface.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author admin
 * @date 2022-04-20 09:54:09
 */
@Data
@TableName("tb_push_log")
public class PushLogEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 任务id
     */
    private String taskId;
    /**
     * 推送内容
     */
    private String result;
    /**
     * 目标手机号
     */
    private String phone;
    /**
     * 推送的短信模板
     */
    private Integer messageTemplate;
    /**
     * 推送目标(别名/cid)
     */
    private String pushTarget;
    /**
     * 推送内容
     */
    private String pushContent;
    /**
     * 到达状态 1001:已推送 1002:已到达 1003:已发送短信
     */
    private Integer arriveStatus;
    /**
     * 备用字段
     */
    private String bas1;
    /**
     * 逻辑删除 1:未删除 0:删除
     */
    @TableLogic(value = "1", delval = "0")
    @TableField(fill = FieldFill.INSERT)
    private Integer isValid;
    /**
     *
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;
    /**
     *
     */
    private Date updateTime;

}
