package com.weface.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.weface.common.utils.*;
import com.weface.component.GeTuiService;
import com.weface.component.MenuService;
import com.weface.component.MobPushService;
import com.weface.config.RedisExpireData;
import com.weface.dto.InformForm;
import com.weface.entity.*;
import com.weface.service.MenuTagsService;
import com.weface.service.PushLogService;
import com.weface.service.UserMenusService;
import com.weface.service.UserTagService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

/**
 * @author Administrator
 * @CreateTime: 2021/11/4
 */
@Component
@Slf4j
@EnableScheduling
public class UserTagsTask {

    @Value("${gexiang.user_tag_id}")
    private String userTagId;
    @Value("${gexiang.push_max_size}")
    private String pushMaxSize;

    @Autowired
    private MenuService menuService;
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private UserMenusService userMenusService;
    @Autowired
    private MenuTagsService menuTagsService;

    @Autowired
    @Qualifier(value = "asyncServiceExecutor")
    private ThreadPoolTaskExecutor asyncServiceExecutor;

    @Autowired
    private PushLogService pushLogService;
    @Autowired
    private MobPushService mobPushService;
    @Autowired
    private GeTuiService geTuiService;

    /**
     * 查询推送日志时间
     */
    private static final Integer TIME = 2;


    /**
     * 定时推送电费花费提醒
     */
    // @Scheduled(cron = "0 0 8 1,15 * ?")
    public void timingPush() {
        log.error("开始推送1,15号");
        //判断当前是否为当月1/15号
        if (DateUtils.isToday(1) || DateUtils.isToday(15)) {
            //获取推送配置信息
            NavigateConfigEntity configByName = pushLogService.getConfigByName(Constant.TIMING_PUSH_CONFIG_NAME);
            if (Objects.isNull(configByName)) {
                return;
            }
            String configContent = configByName.getConfigContent();
            if (StringUtils.isEmpty(configContent)) {
                return;
            }
            //查询老用户
            List<String> list = pushLogService.getOrderUidList().stream().filter(org.apache.commons.lang3.StringUtils::isNumeric).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                //将推送配置json转为推送实体类
                InformForm form = JSONObject.parseObject(configContent, InformForm.class);
                //当天是否为15号
                if (DateUtils.isToday(15)) {
                    //查询14天前至今有缴费记录用户
                    List<String> record = pushLogService.getPayCostRecord().stream().filter(org.apache.commons.lang3.StringUtils::isNumeric).distinct().collect(Collectors.toList());
                    //过滤已缴费用户
                    if (!CollectionUtils.isEmpty(record)) {
                        list.removeAll(record);
                    }
                }
                if (!CollectionUtils.isEmpty(list)) {
                    //分割集合
                    List<List<String>> lists = CommonUtil.fixedGrouping(list, 1000);
                    for (List<String> strings : lists) {
                        //处理推送目标
                        StringBuilder sb = new StringBuilder();
                        for (String s : strings) {
                            sb.append("kksh_").append(s).append(",");
                        }
                        String cid = sb.substring(0, sb.length() - 1);
                        form.setCid(cid);
                        //mob批量推送
                        mobPushService.mobPush(form, Constant.PushTarget.ALIAS);
                        //个推批量推送
                        geTuiService.pushListMessage(form, true);
                    }
                    log.error("本次推送目标数:{}", list.size());
                }
            }
        }
    }


    /**
     * 查询未推送消息成功记录,发送短信通知
     */
    //@Scheduled(cron = "0 0 0/1 * * ?")
    public void sendMessage() {
        try {
            log.error("开始执行短信推送任务");
            List<PushLogEntity> list = pushLogService.getPushLogByTime(TIME);
            if (!CollectionUtils.isEmpty(list)) {
                DES des = DES.getInstanceDes();
                for (PushLogEntity pushLogEntity : list) {
                    String phone = pushLogEntity.getPhone();
                    if (StringUtils.isEmpty(phone)) {
                        continue;
                    }
                    if (CommonUtil.isBase64(phone)) {
                        phone = des.decrypt(phone);
                    }
                    Integer arriveStatus = pushLogEntity.getArriveStatus();
                    if (arriveStatus.equals(1001)) {
                        Integer pushType = pushLogEntity.getPushType();
                        if (Objects.nonNull(pushType)) {
                            String pushContent = pushLogEntity.getPushContent();
                            Integer messageTemplate = pushLogEntity.getMessageTemplate();
                            boolean push = false;
                            //毛博推送
                            if (pushType.equals(2)) {
                                //查询推送记录是否送到
                                push = mobPushService.getPushInfoById(pushLogEntity.getTaskId());
                                //推送已到达
                                if (push) {
                                    pushLogEntity.setArriveStatus(1002);
                                    pushLogEntity.setUpdateTime(new Date());
                                    pushLogService.updateById(pushLogEntity);
                                }
                            }
                            if (!push) {
                                boolean b = ShortMsgSend.sendMobileByRegister(pushContent, phone, messageTemplate);
                                if (b) {
                                    log.error("执行短信发送成功:{}", phone);
                                    pushLogEntity.setArriveStatus(1003);
                                    pushLogEntity.setUpdateTime(new Date());
                                    pushLogService.updateById(pushLogEntity);
                                }
                            }
                        }
                    }
                }
            }
        } catch (IOException e) {
            log.error("执行短信发送失败:{}", e.getMessage());
            e.printStackTrace();
        }
    }


    /**
     * 更新推送任务id缓存
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void updateRedisHashKey() {
        try {
            log.error("开始更新任务缓存");
            Set<Object> hashSet = new HashSet<>();
            Set<Object> keys = RedisUtil.HashOps.hKeys(Constant.PUSH_TASK_INFO);
            for (Object key : keys) {
                Object hashValue = RedisUtil.HashOps.hGet(Constant.PUSH_TASK_INFO, key.toString());
                log.error("缓存任务信息:{}", hashValue);
                if (hashValue != null) {
                    RedisExpireData redisData = JSONUtil.toBean(hashValue.toString(), RedisExpireData.class);
                    Object obj = redisData.getStoreData();
                    if (obj == null) {
                        hashSet.add(key);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(hashSet)) {
                RedisUtil.HashOps.hDelete(Constant.PUSH_TASK_INFO, hashSet.toArray());
            }
        } catch (Exception e) {
            log.error("更新任务缓存失败:{}", e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * 更新用户标签
     */
    //@Scheduled(cron = "0 0 23 * * ?")
    public void updateUserTags() {
        try {
            //获取每次处理的id起始值
            String userId = RedisUtil.StringOps.get("user_tag_id");
            if (StringUtils.isBlank(userId)) {
                userId = userTagId;
            }
            int id = Integer.parseInt(userId);

            //获取缓存内每次处理最大数
            String pushSize = RedisUtil.StringOps.get("push_max_size");
            //如果缓存没有则取配置文件中的
            if (StringUtils.isBlank(pushSize)) {
                RedisUtil.StringOps.set("push_max_size", pushMaxSize);
                pushSize = pushMaxSize;
            } else {
                //如果缓存和配置文件不一致则使用配置文件数值替换缓存
                if (!pushMaxSize.equals(pushSize)) {
                    RedisUtil.StringOps.set("push_max_size", pushMaxSize);
                    pushSize = pushMaxSize;
                }
            }
            int max = Integer.parseInt(pushSize);

            //存储用户标签信息
            List<UserMenusEntity> userMenusList;
            //获取标签列表
            List<MenuTagsEntity> tags = menuTagsService.list();
            //获取小于起始值,且更新时间为当前时间用户信息
            //List<UserTagEntity> beforeUser = userTagService.findUserByTodayAndIdBefore(id);
            //如果每次更新数据为空则全部设置为新增
            //if (CollUtil.isEmpty(beforeUser)) {
            //List<UserMenusEntity> afterTag = getAfterTag(id, max, tags);
            userMenusList = getAfterTag(id, max, tags);
            //if (afterTag != null) {
            // userMenusList.addAll(afterTag);
            //}
            /*} else {
                //过滤用户gid
                List<String> beforeGid = beforeUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
                //获取更新总数量
                int size = beforeGid.size();
                //如果更新数量大于总量,截取每次处理总量的更新用户信息
                if (size > max) {
                    beforeGid = beforeGid.subList(0, max - 1);
                } else {
                    List<UserMenusEntity> afterTag = getAfterTag(id, max - size, tags);
                    if (afterTag != null) {
                        userMenusList.addAll(afterTag);
                    }
                }
                //调用个像接口获取更新用户标签
                List<UserMenusEntity> beforeTag = getUserTag(beforeGid, beforeUser, tags);
                if (CollUtil.isNotEmpty(beforeTag)) {
                    userMenusList.addAll(beforeTag);
                }
            }*/
            //批量插入用户标签信息
            userMenusService.batchInsert(userMenusList);
            log.info("执行结束,当前最新id{}", RedisUtil.StringOps.get("user_tag_id"));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行定时更新标签任务失败!");
        }
    }

    /**
     * 处理新增用户标签
     *
     * @param userId 用户id
     * @param limit  处理条数
     * @param tags   标签信息
     * @return 标签信息
     * @throws InterruptedException 网络异常
     */
    private List<UserMenusEntity> getAfterTag(Integer userId, Integer limit, List<MenuTagsEntity> tags) throws InterruptedException {
        //最大处理数减去当天更新处理数,得到剩余处理数,获取起始值后的新增的用户信息
        List<UserTagEntity> afterUser = userTagService.findUserByIdAfter(userId, limit);
        //如果当天新增数不为空
        if (CollUtil.isNotEmpty(afterUser)) {
            //获取用户最后一条信息
            //UserTagEntity afterUserInfo = afterUser.get(afterUser.size() - 1);
            //并覆盖起始值
            //RedisUtil.StringOps.set("user_tag_id", String.valueOf(afterUserInfo.getId()));
            //过滤用户gid
            List<String> afterGid = afterUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
            //调用个像接口获取新增用户标签
            return getUserTag(afterGid, afterUser, tags);
        }
        return null;
    }

    /**
     * 获取个像用户标签信息
     *
     * @param gid      用户gid
     * @param userInfo 用户信息
     * @param tag      标签信息
     * @return 查询到的用户标签信息
     * @throws InterruptedException 网络异常
     */
    private List<UserMenusEntity> getUserTag(List<String> gid, List<UserTagEntity> userInfo, List<MenuTagsEntity> tag) throws InterruptedException {
        //存储用户标签信息
        List<UserMenusEntity> userTags = new ArrayList<>();
        //获取用户gid总量
        int size = gid.size();
        //每个线程处理1000调数据
        int limit = 200;
        //获取总页数
        int totalPage = (size % limit == 0) ? (size / limit) : (size / limit + 1);
        CountDownLatch latch = new CountDownLatch(totalPage);
        //创建线程
        for (int i = 0; i < totalPage; i++) {
            int finalI = i;
            Runnable runnable = () -> {
                //截取每次处理数据
                List<String> list;
                if (finalI == totalPage - 1) {
                    list = gid.subList(finalI * limit, size);
                } else {
                    list = gid.subList(finalI * limit, (finalI + 1) * limit);
                }
                if (CollUtil.isNotEmpty(list)) {
                    //获取个像数据
                    Map<String, Object> android = menuService.getUserTags(list, tag);
                    if (android != null) {
                        //解析个像数据
                        List<UserMenusEntity> tagUser = menuService.getTagUser(android, userInfo);
                        userTags.addAll(tagUser);
                    }
                }
                latch.countDown();
            };
            asyncServiceExecutor.execute(runnable);
        }
        latch.await();
        return userTags;
    }

}
