package com.weface.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.code.CommonResult;
import com.weface.dto.UserMenuFrom;
import com.weface.entity.UserMenusEntity;

import java.util.List;

/**
 * 用户和标签中间表
 *
 * @author chenshun
 * @date 2021-11-18 16:20:52
 */
public interface UserMenusService extends IService<UserMenusEntity> {

    /**
     * 批量插入
     *
     * @param list 数据列表
     */
    void batchInsert(List<UserMenusEntity> list);

    /**
     * 保存用户标签
     *
     * @param userMenuFrom 标签信息
     * @return 执行结果
     */
    CommonResult saveUserTag(UserMenuFrom userMenuFrom);

    /**
     * 删除用户标签
     *
     * @param userMenuFrom 标签信息
     * @return 执行结果
     */
    CommonResult delUserTag(UserMenuFrom userMenuFrom);
}

