package com.weface.common.utils;

/**
 * 常量
 *
 * @author Mark sunlightcs@gmail.com
 */
public class Constant {
	/** 超级管理员ID */
	public static final int SUPER_ADMIN = 1;
    /**
     * 当前页码
     */
    public static final String PAGE = "page";
    /**
     * 每页显示记录数
     */
    public static final String LIMIT = "limit";
    /**
     * 排序字段
     */
    public static final String ORDER_FIELD = "sidx";
    /**
     * 排序方式
     */
    public static final String ORDER = "order";
    /**
     *  升序
     */
    public static final String ASC = "asc";
    /**
     * DES密钥
     */
    public static final String DES_KEY = "Kkweface55389527";
    /**
     * 状态
     */
    public static final String STATUS = "status";
    /**
     *unknown
     */
    public static final String UN_KNOW = "unknown";
    /**
     *时间戳
     */
    public static final String TIME_NAME = "timestamp";
    /**
     * redis缓存前缀
     */
    public static final String PUSH_TASK_INFO = "push_task_info";
    /**
     * 推送配置名称
     */
    public static final String TIMING_PUSH_CONFIG_NAME = "timingPushConfig";

    /**
     * http 请求
     */
    @SuppressWarnings("unused")
    public enum MethodType {
        /**
         * 请求类型
         */
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        PATCH("PATCH");

        private final String value;

        MethodType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * mob推送目标
     */
    public enum PushTarget {
        RADIO(1, "广播群推"),
        ALIAS(2, "别名推送"),
        TAGS(3, "标签推送"),
        RIDS(4, "rid推送"),
        CITY(5, "地理位置推送"),
        BLOCK(6, "用户分群推送"),
        AREA(9, "复杂地理位置推送"),
        FILE(14, "fileId推送"),
        BATCH_ALIAS(22, "别名批量推送"),
        BATCH_RIDS(33, "rid批量推送");

        private int key;
        private String value;

        PushTarget(int key, String value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
