package com.weface.serviceimpl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.dao.MenuTagsDao;
import com.weface.entity.MenuTagsEntity;
import com.weface.service.MenuTagsService;
import com.weface.common.utils.PageUtils;
import com.weface.common.utils.Query;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * @author Administrator
 */
@Service("menuTagsService")
public class MenuTagsServiceImpl extends ServiceImpl<MenuTagsDao, MenuTagsEntity> implements MenuTagsService {

    /**
     * 列表
     *
     * @param params 参数
     * @return 标签
     */
    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        String levelThird = (String) params.get("levelThird");
        IPage<MenuTagsEntity> page = this.page(
                new Query<MenuTagsEntity>().getPage(params),
                new QueryWrapper<MenuTagsEntity>().lambda().like(StringUtils.isNotBlank(levelThird), MenuTagsEntity::getLevelThird, levelThird)
        );
        return new PageUtils(page);
    }

    /**
     * 根据code和权重查询标签
     *
     * @param code   编码
     * @param weight 权重
     * @return 标签信息
     */
    @Override
    public MenuTagsEntity getOneByCodeOrWeight(String code, String weight) {
        List<MenuTagsEntity> list = this.list(new QueryWrapper<MenuTagsEntity>()
                .lambda().eq(MenuTagsEntity::getCode, code)
                .eq(StringUtils.isNotBlank(weight), MenuTagsEntity::getWeight, weight));
        if (list != null && list.size() > 0) {
            return list.get(0);
        } else {
            return null;
        }
    }

}