package com.weface.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.weface.entity.UserTagEntity;
import com.weface.common.utils.PageUtils;

import java.util.List;
import java.util.Map;

/**
 * 用户ID标签关联表
 *
 * @author chenshun
 * @date 2021-11-30 18:57:06
 */
public interface UserTagService extends IService<UserTagEntity> {

    /**
     * 查询当天的数据
     *
     * @return 当天改变的用户
     */
    List<UserTagEntity> findUserByTodayAndIdBefore(Integer id);

    /**
     * 根据时间查询用户信息
     *
     * @return 用户信息
     */
    List<UserTagEntity> findUserByIdAfter(Integer id, Integer limit);


    /**
     * 查询库中无标签用户
     *
     * @param star 起始值
     * @param end  每页数据
     * @return 用户信息
     */
    List<UserTagEntity> findNoTagUser(Integer star, Integer end);

    /**
     * 查询所有用户对应标签信息
     *
     * @param params 參數
     * @return 分頁信息
     */
    PageUtils getUserAndTags(Map<String, Object> params);


    /**
     * 根据标签查询用户gid
     *
     * @param tags 标签数组
     * @return 用户gid
     */
    List<String> getGidByTag(String[] tags);

    /**
     * 根据gid查询用户标签
     *
     * @param gid 用户gid数组
     * @return 用户信息和标签信息
     */
    Map<String, Object> getTagByGid(String gid);

    /**
     * 获取所有用户的标签信息 导出
     *
     * @return 标签信息
     */
    List<UserTagEntity> getAllImport();


}

