package com.weface;


import com.weface.component.GeTuiUtils;
import com.weface.component.MenuService;
import com.weface.component.MessageTemplate;
import com.weface.entity.MenuTagsEntity;
import com.weface.entity.UserTagEntity;
import com.weface.entity.UserMenusEntity;
import com.weface.service.MenuTagsService;
import com.weface.service.UserTagService;
import com.weface.service.UserMenusService;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

@SpringBootTest
class PushMessageApplicationTests {
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private UserMenusService userMenusService;
    @Autowired
    private MenuTagsService menuTagsService;

    @Test
    void contextLoads() {
    }

    /**
     * 根据时间同步标签
     */
    @Test
    public void testKKSB() {
        try {
            //77164
            //已处理0
            //每次处理总条数 20000
            int star = 10000;
            int end = 30000;
            List<MenuTagsEntity> tags = menuTagsService.list();
            List<UserTagEntity> todayUser = userTagService.findNoTagUser(star, end);
            List<String> todayGid = todayUser.stream().map(UserTagEntity::getGid).distinct().collect(Collectors.toList());
            int size = todayGid.size();
            int limit = 1000;
            List<UserMenusEntity> userMenusList = new ArrayList<>();
            int totalPage = (size % limit == 0) ? (size / limit) : (size / limit + 1);
            CountDownLatch latch = new CountDownLatch(totalPage);
            ExecutorService pool = Executors.newFixedThreadPool(totalPage);
            //收集中间表数据
            for (int i = 0; i < totalPage; i++) {
                int finalI = i;
                Runnable runnable = () -> {
                    List<String> list;
                    if (finalI == totalPage - 1) {
                        list = todayGid.subList(finalI * limit, size);
                    } else {
                        list = todayGid.subList(finalI * limit, (finalI + 1) * limit);
                    }
                    if (CollectionUtils.isNotEmpty(list)) {
                        Map<String, Object> android = menuService.getUserTags(list, tags);
                        List<UserMenusEntity> tagUser = menuService.getTagUser(android, todayUser);
                        if (CollectionUtils.isNotEmpty(tagUser)) {
                            userMenusList.addAll(tagUser);
                        }
                    }
                    latch.countDown();
                };
                pool.execute(runnable);
            }
            latch.await();
            userMenusService.batchInsert(userMenusList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    void testConventTemplate() {
//        String[] alias = {"kksh_10255318"};
//        String[] alias = {"kksh_10131492"};
        String[] alias = {"kksh_59354"};
        String token = GeTuiUtils.getAuthToken("kk_sh_token_ge_tui");
        MessageTemplate messageTemplate = new MessageTemplate();

        MessageTemplate.Settings settings = new MessageTemplate.Settings();
        settings.setTtl(3600000);
        messageTemplate.setSettings(settings);

        MessageTemplate.PushMessage pushMessage = new MessageTemplate.PushMessage();
        MessageTemplate.PushMessage.Notification notification = new MessageTemplate.PushMessage.Notification();
        notification.setTitle("看看生活提醒");
        notification.setBody("看看生活->让领钱更简单");
        notification.setClick_type("url");
        notification.setUrl("https://www.baidu.com/");
        notification.setChannel_level(4);
        pushMessage.setNotification(notification);
        messageTemplate.setPush_message(pushMessage);
        String s = GeTuiUtils.singlePushAlias(alias, messageTemplate, token);
        System.out.println(s);


    }

}
