package com.weface.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.weface.code.PushResultCode;
import com.weface.common.utils.*;
import com.weface.config.GeTuiApp;
import com.weface.config.GeTuiConfig;
import com.weface.dao.PushCallBackDao;
import com.weface.entity.PushCallBackEntity;
import com.weface.entity.PushLogEntity;
import com.weface.service.PushCallBackService;
import com.weface.service.PushLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author : Administrator
 * @date : 2022/4/19 14:08
 */
@Service("pushCallBackService")
@Slf4j
@Transactional(rollbackFor = {Exception.class})
public class PushCallBackServiceImpl extends ServiceImpl<PushCallBackDao, PushCallBackEntity> implements PushCallBackService {

    @Resource
    private GeTuiApp geTuiApp;
    @Autowired
    private PushLogService pushLogService;

    /**
     * 保存推送回调
     *
     * @param request 回调请求
     * @return 执行结果
     */
    @Override
    public PushResultCode saveCallBackInfo(HttpServletRequest request) {
        try {
            List<PushCallBackEntity> list = getCallBackInfo(request);
            if (list.isEmpty()) {
                return PushResultCode.error();
            }
            for (PushCallBackEntity callBackInfo : list) {
                String appId = callBackInfo.getAppid();
                String taskId = callBackInfo.getTaskid();
                String str = appId + callBackInfo.getCid() + taskId + callBackInfo.getMsgid() + getMasterSecret(appId);
                String sign = Base64Util.md5Encode(str);
                if (!callBackInfo.getSign().equals(sign)) {
                    return PushResultCode.error();
                }
                if (taskId.startsWith("RASS")) {
                    Object hashValue = RedisUtil.HashOps.hGet(Constant.PUSH_TASK_INFO, taskId);
                    if (hashValue != null) {
                        PushLogEntity pushLog = pushLogService.getPushLog(taskId);
                        if (pushLog != null) {
                            //更新推送日志
                            pushLog.setArriveStatus(1002);
                            pushLogService.updateById(pushLog);
                            log.error("推送回调消息:{}", taskId);
                            //持久化回调日志
                            callBackInfo.setId(SnowIdUtil.nextId());
                            callBackInfo.setUpdateTime(new Date());
                            callBackInfo.setStatus(1);
                            this.save(callBackInfo);
                        }
                    }
                }
            }
            return PushResultCode.ok();
        } catch (IOException e) {
            log.error("处理回调函数异常:{}", e.getMessage());
            e.printStackTrace();
        }
        return PushResultCode.error();
    }


    /**
     * 获取应用密钥
     *
     * @param appId 应用id
     * @return 应用密钥
     */
    private String getMasterSecret(String appId) {
        String masterSecret = null;
        Map<String, GeTuiConfig> apps = geTuiApp.getApps();
        for (Map.Entry<String, GeTuiConfig> entry : apps.entrySet()) {
            if (appId.equals(entry.getValue().getAppId())) {
                masterSecret = entry.getValue().getMastersecret();
                break;
            }
        }
        return masterSecret;
    }


    /**
     * 解析请求数据
     *
     * @param request 请求
     * @return 解析后回调对象
     * @throws IOException 网络流异常
     */
    public static List<PushCallBackEntity> getCallBackInfo(HttpServletRequest request) throws IOException {
        byte[] bytes = HttpUtil.getRequestInputStream(request);
        String callBackList = new String(bytes);
        Pattern re = Pattern.compile("(\\{.*?})");
        Matcher matcher = re.matcher(callBackList);
        List<PushCallBackEntity> list = new ArrayList<>();
        while (matcher.find()) {
            String group = matcher.group(1);
            log.info("回调信息:{}", group);
            PushCallBackEntity callBackInfo = JSONObject.parseObject(group, PushCallBackEntity.class);
            String desc = JSONObject.parseObject(group).getString("desc");
            callBackInfo.setDescStr(desc);
            list.add(callBackInfo);
        }
        return list;
    }


}
